/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class EndpointDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final List<KeyValuePair> recordProperties;
    protected final List<PascalString> discoveryUrls;
    protected final PascalString networkName;
    protected final int port;

    @Override
    public Integer getExtensionId() {
        return 15559;
    }

    public EndpointDataType(PascalString name, List<KeyValuePair> recordProperties, List<PascalString> discoveryUrls, PascalString networkName, int port) {
        this.name = name;
        this.recordProperties = recordProperties;
        this.discoveryUrls = discoveryUrls;
        this.networkName = networkName;
        this.port = port;
    }

    public PascalString getName() {
        return this.name;
    }

    public List<KeyValuePair> getRecordProperties() {
        return this.recordProperties;
    }

    public List<PascalString> getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    public PascalString getNetworkName() {
        return this.networkName;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EndpointDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfRecordProperties = this.getRecordProperties() == null ? -1 : StaticHelper.COUNT(this.getRecordProperties());
        FieldWriterFactory.writeImplicitField((String)"noOfRecordProperties", (Object)noOfRecordProperties, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"recordProperties", this.recordProperties, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDiscoveryUrls = this.getDiscoveryUrls() == null ? -1 : StaticHelper.COUNT(this.getDiscoveryUrls());
        FieldWriterFactory.writeImplicitField((String)"noOfDiscoveryUrls", (Object)noOfDiscoveryUrls, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"discoveryUrls", this.discoveryUrls, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"networkName", (Object)this.networkName, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"port", (Object)this.port, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("EndpointDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        EndpointDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += 32;
        if (this.recordProperties != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.recordProperties) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.recordProperties.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.discoveryUrls != null) {
            i = 0;
            for (PascalString pascalString : this.discoveryUrls) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.discoveryUrls.size());
                lengthInBits += pascalString.getLengthInBits();
            }
        }
        lengthInBits += this.networkName.getLengthInBits();
        return lengthInBits += 16;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("EndpointDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfRecordProperties = (Integer)FieldReaderFactory.readImplicitField((String)"noOfRecordProperties", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List recordProperties = FieldReaderFactory.readCountArrayField((String)"recordProperties", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfRecordProperties, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDiscoveryUrls = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDiscoveryUrls", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List discoveryUrls = FieldReaderFactory.readCountArrayField((String)"discoveryUrls", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfDiscoveryUrls, (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString networkName = (PascalString)FieldReaderFactory.readSimpleField((String)"networkName", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int port = (Integer)FieldReaderFactory.readSimpleField((String)"port", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("EndpointDataType", new WithReaderArgs[0]);
        return new EndpointDataTypeBuilderImpl(name, recordProperties, discoveryUrls, networkName, port);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointDataType)) {
            return false;
        }
        EndpointDataType that = (EndpointDataType)o;
        return this.getName() == that.getName() && this.getRecordProperties() == that.getRecordProperties() && this.getDiscoveryUrls() == that.getDiscoveryUrls() && this.getNetworkName() == that.getNetworkName() && this.getPort() == that.getPort() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getRecordProperties(), this.getDiscoveryUrls(), this.getNetworkName(), this.getPort());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class EndpointDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final List<KeyValuePair> recordProperties;
        private final List<PascalString> discoveryUrls;
        private final PascalString networkName;
        private final int port;

        public EndpointDataTypeBuilderImpl(PascalString name, List<KeyValuePair> recordProperties, List<PascalString> discoveryUrls, PascalString networkName, int port) {
            this.name = name;
            this.recordProperties = recordProperties;
            this.discoveryUrls = discoveryUrls;
            this.networkName = networkName;
            this.port = port;
        }

        @Override
        public EndpointDataType build() {
            EndpointDataType endpointDataType = new EndpointDataType(this.name, this.recordProperties, this.discoveryUrls, this.networkName, this.port);
            return endpointDataType;
        }
    }
}

