/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ApplicationDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.UserTokenPolicy;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class EndpointDescription
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString endpointUrl;
    protected final ApplicationDescription server;
    protected final PascalByteString serverCertificate;
    protected final MessageSecurityMode securityMode;
    protected final PascalString securityPolicyUri;
    protected final List<UserTokenPolicy> userIdentityTokens;
    protected final PascalString transportProfileUri;
    protected final short securityLevel;

    @Override
    public Integer getExtensionId() {
        return 314;
    }

    public EndpointDescription(PascalString endpointUrl, ApplicationDescription server, PascalByteString serverCertificate, MessageSecurityMode securityMode, PascalString securityPolicyUri, List<UserTokenPolicy> userIdentityTokens, PascalString transportProfileUri, short securityLevel) {
        this.endpointUrl = endpointUrl;
        this.server = server;
        this.serverCertificate = serverCertificate;
        this.securityMode = securityMode;
        this.securityPolicyUri = securityPolicyUri;
        this.userIdentityTokens = userIdentityTokens;
        this.transportProfileUri = transportProfileUri;
        this.securityLevel = securityLevel;
    }

    public PascalString getEndpointUrl() {
        return this.endpointUrl;
    }

    public ApplicationDescription getServer() {
        return this.server;
    }

    public PascalByteString getServerCertificate() {
        return this.serverCertificate;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public PascalString getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public List<UserTokenPolicy> getUserIdentityTokens() {
        return this.userIdentityTokens;
    }

    public PascalString getTransportProfileUri() {
        return this.transportProfileUri;
    }

    public short getSecurityLevel() {
        return this.securityLevel;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EndpointDescription", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"endpointUrl", (Object)this.endpointUrl, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"server", (Object)this.server, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serverCertificate", (Object)this.serverCertificate, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"securityMode", (String)"MessageSecurityMode", (Object)((Object)this.securityMode), (DataWriter)DataWriterFactory.writeEnum(MessageSecurityMode::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"securityPolicyUri", (Object)this.securityPolicyUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfUserIdentityTokens = this.getUserIdentityTokens() == null ? -1 : StaticHelper.COUNT(this.getUserIdentityTokens());
        FieldWriterFactory.writeImplicitField((String)"noOfUserIdentityTokens", (Object)noOfUserIdentityTokens, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"userIdentityTokens", this.userIdentityTokens, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"transportProfileUri", (Object)this.transportProfileUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"securityLevel", (Object)this.securityLevel, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("EndpointDescription", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        EndpointDescription _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.endpointUrl.getLengthInBits();
        lengthInBits += this.server.getLengthInBits();
        lengthInBits += this.serverCertificate.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += this.securityPolicyUri.getLengthInBits();
        lengthInBits += 32;
        if (this.userIdentityTokens != null) {
            int i = 0;
            for (UserTokenPolicy element : this.userIdentityTokens) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.userIdentityTokens.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        lengthInBits += this.transportProfileUri.getLengthInBits();
        return lengthInBits += 8;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("EndpointDescription", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString endpointUrl = (PascalString)FieldReaderFactory.readSimpleField((String)"endpointUrl", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ApplicationDescription server = (ApplicationDescription)FieldReaderFactory.readSimpleField((String)"server", (DataReader)DataReaderFactory.readComplex(() -> (ApplicationDescription)ExtensionObjectDefinition.staticParse(readBuffer, 310), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalByteString serverCertificate = (PascalByteString)FieldReaderFactory.readSimpleField((String)"serverCertificate", (DataReader)DataReaderFactory.readComplex(() -> PascalByteString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        MessageSecurityMode securityMode = (MessageSecurityMode)((Object)FieldReaderFactory.readEnumField((String)"securityMode", (String)"MessageSecurityMode", (DataReader)DataReaderFactory.readEnum(MessageSecurityMode::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        PascalString securityPolicyUri = (PascalString)FieldReaderFactory.readSimpleField((String)"securityPolicyUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfUserIdentityTokens = (Integer)FieldReaderFactory.readImplicitField((String)"noOfUserIdentityTokens", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List userIdentityTokens = FieldReaderFactory.readCountArrayField((String)"userIdentityTokens", (DataReader)DataReaderFactory.readComplex(() -> (UserTokenPolicy)ExtensionObjectDefinition.staticParse(readBuffer, 306), (ReadBuffer)readBuffer), (long)noOfUserIdentityTokens, (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString transportProfileUri = (PascalString)FieldReaderFactory.readSimpleField((String)"transportProfileUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short securityLevel = (Short)FieldReaderFactory.readSimpleField((String)"securityLevel", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("EndpointDescription", new WithReaderArgs[0]);
        return new EndpointDescriptionBuilderImpl(endpointUrl, server, serverCertificate, securityMode, securityPolicyUri, userIdentityTokens, transportProfileUri, securityLevel);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointDescription)) {
            return false;
        }
        EndpointDescription that = (EndpointDescription)o;
        return this.getEndpointUrl() == that.getEndpointUrl() && this.getServer() == that.getServer() && this.getServerCertificate() == that.getServerCertificate() && this.getSecurityMode() == that.getSecurityMode() && this.getSecurityPolicyUri() == that.getSecurityPolicyUri() && this.getUserIdentityTokens() == that.getUserIdentityTokens() && this.getTransportProfileUri() == that.getTransportProfileUri() && this.getSecurityLevel() == that.getSecurityLevel() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getEndpointUrl(), this.getServer(), this.getServerCertificate(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getUserIdentityTokens(), this.getTransportProfileUri(), this.getSecurityLevel()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class EndpointDescriptionBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString endpointUrl;
        private final ApplicationDescription server;
        private final PascalByteString serverCertificate;
        private final MessageSecurityMode securityMode;
        private final PascalString securityPolicyUri;
        private final List<UserTokenPolicy> userIdentityTokens;
        private final PascalString transportProfileUri;
        private final short securityLevel;

        public EndpointDescriptionBuilderImpl(PascalString endpointUrl, ApplicationDescription server, PascalByteString serverCertificate, MessageSecurityMode securityMode, PascalString securityPolicyUri, List<UserTokenPolicy> userIdentityTokens, PascalString transportProfileUri, short securityLevel) {
            this.endpointUrl = endpointUrl;
            this.server = server;
            this.serverCertificate = serverCertificate;
            this.securityMode = securityMode;
            this.securityPolicyUri = securityPolicyUri;
            this.userIdentityTokens = userIdentityTokens;
            this.transportProfileUri = transportProfileUri;
            this.securityLevel = securityLevel;
        }

        @Override
        public EndpointDescription build() {
            EndpointDescription endpointDescription = new EndpointDescription(this.endpointUrl, this.server, this.serverCertificate, this.securityMode, this.securityPolicyUri, this.userIdentityTokens, this.transportProfileUri, this.securityLevel);
            return endpointDescription;
        }
    }
}

