/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectWithMask;
import org.apache.plc4x.java.opcua.readwrite.RootExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class ExtensionObject
implements Message {
    protected final ExpandedNodeId typeId;

    public abstract Boolean getIncludeEncodingMask();

    public ExtensionObject(ExpandedNodeId typeId) {
        this.typeId = typeId;
    }

    public abstract ExtensionObjectDefinition getBody();

    public ExpandedNodeId getTypeId() {
        return this.typeId;
    }

    public int getExtensionId() {
        return this.getTypeId() == null ? 0 : StaticHelper.extensionId(this.getTypeId());
    }

    protected abstract void serializeExtensionObjectChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ExtensionObject", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"typeId", (Object)this.typeId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int extensionId = this.getExtensionId();
        writeBuffer.writeVirtual("extensionId", (Object)extensionId, new WithWriterArgs[0]);
        this.serializeExtensionObjectChild(writeBuffer);
        writeBuffer.popContext("ExtensionObject", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        ExtensionObject _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.typeId.getLengthInBits();
    }

    public static ExtensionObject staticParse(ReadBuffer readBuffer, Boolean includeEncodingMask) throws ParseException {
        readBuffer.pullContext("ExtensionObject", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ExpandedNodeId typeId = (ExpandedNodeId)FieldReaderFactory.readSimpleField((String)"typeId", (DataReader)DataReaderFactory.readComplex(() -> ExpandedNodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int extensionId = (Integer)FieldReaderFactory.readVirtualField((String)"extensionId", Integer.TYPE, (Object)(typeId == null ? 0 : StaticHelper.extensionId(typeId)), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObjectBuilder builder = null;
        if (EvaluationHelper.equals((Object)includeEncodingMask, (Object)false)) {
            builder = RootExtensionObject.staticParseExtensionObjectBuilder(readBuffer, extensionId, includeEncodingMask);
        } else if (EvaluationHelper.equals((Object)includeEncodingMask, (Object)true)) {
            builder = ExtensionObjectWithMask.staticParseExtensionObjectBuilder(readBuffer, extensionId, includeEncodingMask);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [includeEncodingMask=" + includeEncodingMask + "]");
        }
        readBuffer.closeContext("ExtensionObject", new WithReaderArgs[0]);
        ExtensionObject _extensionObject = builder.build(typeId);
        return _extensionObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtensionObject)) {
            return false;
        }
        ExtensionObject that = (ExtensionObject)o;
        return this.getTypeId() == that.getTypeId();
    }

    public int hashCode() {
        return Objects.hash(this.getTypeId());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface ExtensionObjectBuilder {
        public ExtensionObject build(ExpandedNodeId var1);
    }
}

