/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.EndpointDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ResponseHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class GetEndpointsResponse
extends ExtensionObjectDefinition
implements Message {
    protected final ResponseHeader responseHeader;
    protected final List<EndpointDescription> endpoints;

    @Override
    public Integer getExtensionId() {
        return 431;
    }

    public GetEndpointsResponse(ResponseHeader responseHeader, List<EndpointDescription> endpoints) {
        this.responseHeader = responseHeader;
        this.endpoints = endpoints;
    }

    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public List<EndpointDescription> getEndpoints() {
        return this.endpoints;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("GetEndpointsResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"responseHeader", (Object)this.responseHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfEndpoints = this.getEndpoints() == null ? -1 : StaticHelper.COUNT(this.getEndpoints());
        FieldWriterFactory.writeImplicitField((String)"noOfEndpoints", (Object)noOfEndpoints, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"endpoints", this.endpoints, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("GetEndpointsResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        GetEndpointsResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.responseHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.endpoints != null) {
            int i = 0;
            for (EndpointDescription element : this.endpoints) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.endpoints.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("GetEndpointsResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ResponseHeader responseHeader = (ResponseHeader)FieldReaderFactory.readSimpleField((String)"responseHeader", (DataReader)DataReaderFactory.readComplex(() -> (ResponseHeader)ExtensionObjectDefinition.staticParse(readBuffer, 394), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfEndpoints = (Integer)FieldReaderFactory.readImplicitField((String)"noOfEndpoints", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List endpoints = FieldReaderFactory.readCountArrayField((String)"endpoints", (DataReader)DataReaderFactory.readComplex(() -> (EndpointDescription)ExtensionObjectDefinition.staticParse(readBuffer, 314), (ReadBuffer)readBuffer), (long)noOfEndpoints, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("GetEndpointsResponse", new WithReaderArgs[0]);
        return new GetEndpointsResponseBuilderImpl(responseHeader, endpoints);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetEndpointsResponse)) {
            return false;
        }
        GetEndpointsResponse that = (GetEndpointsResponse)o;
        return this.getResponseHeader() == that.getResponseHeader() && this.getEndpoints() == that.getEndpoints() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseHeader(), this.getEndpoints());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class GetEndpointsResponseBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ResponseHeader responseHeader;
        private final List<EndpointDescription> endpoints;

        public GetEndpointsResponseBuilderImpl(ResponseHeader responseHeader, List<EndpointDescription> endpoints) {
            this.responseHeader = responseHeader;
            this.endpoints = endpoints;
        }

        @Override
        public GetEndpointsResponse build() {
            GetEndpointsResponse getEndpointsResponse = new GetEndpointsResponse(this.responseHeader, this.endpoints);
            return getEndpointsResponse;
        }
    }
}

