/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class HistoryEventFieldList
extends ExtensionObjectDefinition
implements Message {
    protected final List<Variant> eventFields;

    @Override
    public Integer getExtensionId() {
        return 922;
    }

    public HistoryEventFieldList(List<Variant> eventFields) {
        this.eventFields = eventFields;
    }

    public List<Variant> getEventFields() {
        return this.eventFields;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryEventFieldList", new WithWriterArgs[0]);
        int noOfEventFields = this.getEventFields() == null ? -1 : StaticHelper.COUNT(this.getEventFields());
        FieldWriterFactory.writeImplicitField((String)"noOfEventFields", (Object)noOfEventFields, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"eventFields", this.eventFields, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryEventFieldList", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryEventFieldList _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.eventFields != null) {
            int i = 0;
            for (Variant element : this.eventFields) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.eventFields.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("HistoryEventFieldList", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfEventFields = (Integer)FieldReaderFactory.readImplicitField((String)"noOfEventFields", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List eventFields = FieldReaderFactory.readCountArrayField((String)"eventFields", (DataReader)DataReaderFactory.readComplex(() -> Variant.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfEventFields, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryEventFieldList", new WithReaderArgs[0]);
        return new HistoryEventFieldListBuilderImpl(eventFields);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryEventFieldList)) {
            return false;
        }
        HistoryEventFieldList that = (HistoryEventFieldList)o;
        return this.getEventFields() == that.getEventFields() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEventFields());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryEventFieldListBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<Variant> eventFields;

        public HistoryEventFieldListBuilderImpl(List<Variant> eventFields) {
            this.eventFields = eventFields;
        }

        @Override
        public HistoryEventFieldList build() {
            HistoryEventFieldList historyEventFieldList = new HistoryEventFieldList(this.eventFields);
            return historyEventFieldList;
        }
    }
}

