/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.HistoryReadValueId;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.TimestampsToReturn;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class HistoryReadRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final ExtensionObject historyReadDetails;
    protected final TimestampsToReturn timestampsToReturn;
    protected final boolean releaseContinuationPoints;
    protected final List<HistoryReadValueId> nodesToRead;

    @Override
    public Integer getExtensionId() {
        return 664;
    }

    public HistoryReadRequest(RequestHeader requestHeader, ExtensionObject historyReadDetails, TimestampsToReturn timestampsToReturn, boolean releaseContinuationPoints, List<HistoryReadValueId> nodesToRead) {
        this.requestHeader = requestHeader;
        this.historyReadDetails = historyReadDetails;
        this.timestampsToReturn = timestampsToReturn;
        this.releaseContinuationPoints = releaseContinuationPoints;
        this.nodesToRead = nodesToRead;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ExtensionObject getHistoryReadDetails() {
        return this.historyReadDetails;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public boolean getReleaseContinuationPoints() {
        return this.releaseContinuationPoints;
    }

    public List<HistoryReadValueId> getNodesToRead() {
        return this.nodesToRead;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryReadRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"historyReadDetails", (Object)this.historyReadDetails, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"timestampsToReturn", (String)"TimestampsToReturn", (Object)((Object)this.timestampsToReturn), (DataWriter)DataWriterFactory.writeEnum(TimestampsToReturn::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"releaseContinuationPoints", (Object)this.releaseContinuationPoints, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfNodesToRead = this.getNodesToRead() == null ? -1 : StaticHelper.COUNT(this.getNodesToRead());
        FieldWriterFactory.writeImplicitField((String)"noOfNodesToRead", (Object)noOfNodesToRead, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"nodesToRead", this.nodesToRead, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryReadRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryReadRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += this.historyReadDetails.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += 32;
        if (this.nodesToRead != null) {
            int i = 0;
            for (HistoryReadValueId element : this.nodesToRead) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.nodesToRead.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("HistoryReadRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject historyReadDetails = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"historyReadDetails", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        TimestampsToReturn timestampsToReturn = (TimestampsToReturn)((Object)FieldReaderFactory.readEnumField((String)"timestampsToReturn", (String)"TimestampsToReturn", (DataReader)DataReaderFactory.readEnum(TimestampsToReturn::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean releaseContinuationPoints = (Boolean)FieldReaderFactory.readSimpleField((String)"releaseContinuationPoints", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfNodesToRead = (Integer)FieldReaderFactory.readImplicitField((String)"noOfNodesToRead", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List nodesToRead = FieldReaderFactory.readCountArrayField((String)"nodesToRead", (DataReader)DataReaderFactory.readComplex(() -> (HistoryReadValueId)ExtensionObjectDefinition.staticParse(readBuffer, 637), (ReadBuffer)readBuffer), (long)noOfNodesToRead, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryReadRequest", new WithReaderArgs[0]);
        return new HistoryReadRequestBuilderImpl(requestHeader, historyReadDetails, timestampsToReturn, releaseContinuationPoints, nodesToRead);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryReadRequest)) {
            return false;
        }
        HistoryReadRequest that = (HistoryReadRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getHistoryReadDetails() == that.getHistoryReadDetails() && this.getTimestampsToReturn() == that.getTimestampsToReturn() && this.getReleaseContinuationPoints() == that.getReleaseContinuationPoints() && this.getNodesToRead() == that.getNodesToRead() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getRequestHeader(), this.getHistoryReadDetails(), this.getTimestampsToReturn(), this.getReleaseContinuationPoints(), this.getNodesToRead()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryReadRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final ExtensionObject historyReadDetails;
        private final TimestampsToReturn timestampsToReturn;
        private final boolean releaseContinuationPoints;
        private final List<HistoryReadValueId> nodesToRead;

        public HistoryReadRequestBuilderImpl(RequestHeader requestHeader, ExtensionObject historyReadDetails, TimestampsToReturn timestampsToReturn, boolean releaseContinuationPoints, List<HistoryReadValueId> nodesToRead) {
            this.requestHeader = requestHeader;
            this.historyReadDetails = historyReadDetails;
            this.timestampsToReturn = timestampsToReturn;
            this.releaseContinuationPoints = releaseContinuationPoints;
            this.nodesToRead = nodesToRead;
        }

        @Override
        public HistoryReadRequest build() {
            HistoryReadRequest historyReadRequest = new HistoryReadRequest(this.requestHeader, this.historyReadDetails, this.timestampsToReturn, this.releaseContinuationPoints, this.nodesToRead);
            return historyReadRequest;
        }
    }
}

