/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ActionMethodDataType;
import org.apache.plc4x.java.opcua.readwrite.ActionTargetDataType;
import org.apache.plc4x.java.opcua.readwrite.DataSetMetaDataType;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class JsonActionMetaDataMessage
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString messageId;
    protected final PascalString messageType;
    protected final PascalString publisherId;
    protected final int dataSetWriterId;
    protected final PascalString dataSetWriterName;
    protected final long timestamp;
    protected final List<ActionTargetDataType> actionTargets;
    protected final DataSetMetaDataType request;
    protected final DataSetMetaDataType response;
    protected final List<ActionMethodDataType> actionMethods;

    @Override
    public Integer getExtensionId() {
        return 19320;
    }

    public JsonActionMetaDataMessage(PascalString messageId, PascalString messageType, PascalString publisherId, int dataSetWriterId, PascalString dataSetWriterName, long timestamp, List<ActionTargetDataType> actionTargets, DataSetMetaDataType request, DataSetMetaDataType response, List<ActionMethodDataType> actionMethods) {
        this.messageId = messageId;
        this.messageType = messageType;
        this.publisherId = publisherId;
        this.dataSetWriterId = dataSetWriterId;
        this.dataSetWriterName = dataSetWriterName;
        this.timestamp = timestamp;
        this.actionTargets = actionTargets;
        this.request = request;
        this.response = response;
        this.actionMethods = actionMethods;
    }

    public PascalString getMessageId() {
        return this.messageId;
    }

    public PascalString getMessageType() {
        return this.messageType;
    }

    public PascalString getPublisherId() {
        return this.publisherId;
    }

    public int getDataSetWriterId() {
        return this.dataSetWriterId;
    }

    public PascalString getDataSetWriterName() {
        return this.dataSetWriterName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<ActionTargetDataType> getActionTargets() {
        return this.actionTargets;
    }

    public DataSetMetaDataType getRequest() {
        return this.request;
    }

    public DataSetMetaDataType getResponse() {
        return this.response;
    }

    public List<ActionMethodDataType> getActionMethods() {
        return this.actionMethods;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("JsonActionMetaDataMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageId", (Object)this.messageId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageType", (Object)this.messageType, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"publisherId", (Object)this.publisherId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataSetWriterId", (Object)this.dataSetWriterId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataSetWriterName", (Object)this.dataSetWriterName, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"timestamp", (Object)this.timestamp, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfActionTargets = this.getActionTargets() == null ? -1 : StaticHelper.COUNT(this.getActionTargets());
        FieldWriterFactory.writeImplicitField((String)"noOfActionTargets", (Object)noOfActionTargets, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"actionTargets", this.actionTargets, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"request", (Object)this.request, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"response", (Object)this.response, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfActionMethods = this.getActionMethods() == null ? -1 : StaticHelper.COUNT(this.getActionMethods());
        FieldWriterFactory.writeImplicitField((String)"noOfActionMethods", (Object)noOfActionMethods, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"actionMethods", this.actionMethods, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("JsonActionMetaDataMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        JsonActionMetaDataMessage _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.messageId.getLengthInBits();
        lengthInBits += this.messageType.getLengthInBits();
        lengthInBits += this.publisherId.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += this.dataSetWriterName.getLengthInBits();
        lengthInBits += 64;
        lengthInBits += 32;
        if (this.actionTargets != null) {
            i = 0;
            for (ActionTargetDataType actionTargetDataType : this.actionTargets) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.actionTargets.size());
                lengthInBits += actionTargetDataType.getLengthInBits();
            }
        }
        lengthInBits += this.request.getLengthInBits();
        lengthInBits += this.response.getLengthInBits();
        lengthInBits += 32;
        if (this.actionMethods != null) {
            i = 0;
            for (ActionMethodDataType actionMethodDataType : this.actionMethods) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.actionMethods.size());
                lengthInBits += actionMethodDataType.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("JsonActionMetaDataMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString messageId = (PascalString)FieldReaderFactory.readSimpleField((String)"messageId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString messageType = (PascalString)FieldReaderFactory.readSimpleField((String)"messageType", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString publisherId = (PascalString)FieldReaderFactory.readSimpleField((String)"publisherId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int dataSetWriterId = (Integer)FieldReaderFactory.readSimpleField((String)"dataSetWriterId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString dataSetWriterName = (PascalString)FieldReaderFactory.readSimpleField((String)"dataSetWriterName", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long timestamp = (Long)FieldReaderFactory.readSimpleField((String)"timestamp", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfActionTargets = (Integer)FieldReaderFactory.readImplicitField((String)"noOfActionTargets", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List actionTargets = FieldReaderFactory.readCountArrayField((String)"actionTargets", (DataReader)DataReaderFactory.readComplex(() -> (ActionTargetDataType)ExtensionObjectDefinition.staticParse(readBuffer, 18595), (ReadBuffer)readBuffer), (long)noOfActionTargets, (WithReaderArgs[])new WithReaderArgs[0]);
        DataSetMetaDataType request = (DataSetMetaDataType)FieldReaderFactory.readSimpleField((String)"request", (DataReader)DataReaderFactory.readComplex(() -> (DataSetMetaDataType)ExtensionObjectDefinition.staticParse(readBuffer, 14525), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        DataSetMetaDataType response = (DataSetMetaDataType)FieldReaderFactory.readSimpleField((String)"response", (DataReader)DataReaderFactory.readComplex(() -> (DataSetMetaDataType)ExtensionObjectDefinition.staticParse(readBuffer, 14525), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfActionMethods = (Integer)FieldReaderFactory.readImplicitField((String)"noOfActionMethods", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List actionMethods = FieldReaderFactory.readCountArrayField((String)"actionMethods", (DataReader)DataReaderFactory.readComplex(() -> (ActionMethodDataType)ExtensionObjectDefinition.staticParse(readBuffer, 18599), (ReadBuffer)readBuffer), (long)noOfActionMethods, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("JsonActionMetaDataMessage", new WithReaderArgs[0]);
        return new JsonActionMetaDataMessageBuilderImpl(messageId, messageType, publisherId, dataSetWriterId, dataSetWriterName, timestamp, actionTargets, request, response, actionMethods);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonActionMetaDataMessage)) {
            return false;
        }
        JsonActionMetaDataMessage that = (JsonActionMetaDataMessage)o;
        return this.getMessageId() == that.getMessageId() && this.getMessageType() == that.getMessageType() && this.getPublisherId() == that.getPublisherId() && this.getDataSetWriterId() == that.getDataSetWriterId() && this.getDataSetWriterName() == that.getDataSetWriterName() && this.getTimestamp() == that.getTimestamp() && this.getActionTargets() == that.getActionTargets() && this.getRequest() == that.getRequest() && this.getResponse() == that.getResponse() && this.getActionMethods() == that.getActionMethods() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMessageId(), this.getMessageType(), this.getPublisherId(), this.getDataSetWriterId(), this.getDataSetWriterName(), this.getTimestamp(), this.getActionTargets(), this.getRequest(), this.getResponse(), this.getActionMethods());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class JsonActionMetaDataMessageBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString messageId;
        private final PascalString messageType;
        private final PascalString publisherId;
        private final int dataSetWriterId;
        private final PascalString dataSetWriterName;
        private final long timestamp;
        private final List<ActionTargetDataType> actionTargets;
        private final DataSetMetaDataType request;
        private final DataSetMetaDataType response;
        private final List<ActionMethodDataType> actionMethods;

        public JsonActionMetaDataMessageBuilderImpl(PascalString messageId, PascalString messageType, PascalString publisherId, int dataSetWriterId, PascalString dataSetWriterName, long timestamp, List<ActionTargetDataType> actionTargets, DataSetMetaDataType request, DataSetMetaDataType response, List<ActionMethodDataType> actionMethods) {
            this.messageId = messageId;
            this.messageType = messageType;
            this.publisherId = publisherId;
            this.dataSetWriterId = dataSetWriterId;
            this.dataSetWriterName = dataSetWriterName;
            this.timestamp = timestamp;
            this.actionTargets = actionTargets;
            this.request = request;
            this.response = response;
            this.actionMethods = actionMethods;
        }

        @Override
        public JsonActionMetaDataMessage build() {
            JsonActionMetaDataMessage jsonActionMetaDataMessage = new JsonActionMetaDataMessage(this.messageId, this.messageType, this.publisherId, this.dataSetWriterId, this.dataSetWriterName, this.timestamp, this.actionTargets, this.request, this.response, this.actionMethods);
            return jsonActionMetaDataMessage;
        }
    }
}

