/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class JsonActionNetworkMessage
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString messageId;
    protected final PascalString messageType;
    protected final PascalString publisherId;
    protected final long timestamp;
    protected final PascalString responseAddress;
    protected final PascalByteString correlationData;
    protected final PascalString requestorId;
    protected final double timeoutHint;
    protected final List<ExtensionObject> messages;

    @Override
    public Integer getExtensionId() {
        return 19322;
    }

    public JsonActionNetworkMessage(PascalString messageId, PascalString messageType, PascalString publisherId, long timestamp, PascalString responseAddress, PascalByteString correlationData, PascalString requestorId, double timeoutHint, List<ExtensionObject> messages) {
        this.messageId = messageId;
        this.messageType = messageType;
        this.publisherId = publisherId;
        this.timestamp = timestamp;
        this.responseAddress = responseAddress;
        this.correlationData = correlationData;
        this.requestorId = requestorId;
        this.timeoutHint = timeoutHint;
        this.messages = messages;
    }

    public PascalString getMessageId() {
        return this.messageId;
    }

    public PascalString getMessageType() {
        return this.messageType;
    }

    public PascalString getPublisherId() {
        return this.publisherId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public PascalString getResponseAddress() {
        return this.responseAddress;
    }

    public PascalByteString getCorrelationData() {
        return this.correlationData;
    }

    public PascalString getRequestorId() {
        return this.requestorId;
    }

    public double getTimeoutHint() {
        return this.timeoutHint;
    }

    public List<ExtensionObject> getMessages() {
        return this.messages;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("JsonActionNetworkMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageId", (Object)this.messageId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageType", (Object)this.messageType, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"publisherId", (Object)this.publisherId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"timestamp", (Object)this.timestamp, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"responseAddress", (Object)this.responseAddress, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"correlationData", (Object)this.correlationData, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestorId", (Object)this.requestorId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"timeoutHint", (Object)this.timeoutHint, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfMessages = this.getMessages() == null ? -1 : StaticHelper.COUNT(this.getMessages());
        FieldWriterFactory.writeImplicitField((String)"noOfMessages", (Object)noOfMessages, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"messages", this.messages, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("JsonActionNetworkMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        JsonActionNetworkMessage _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.messageId.getLengthInBits();
        lengthInBits += this.messageType.getLengthInBits();
        lengthInBits += this.publisherId.getLengthInBits();
        lengthInBits += 64;
        lengthInBits += this.responseAddress.getLengthInBits();
        lengthInBits += this.correlationData.getLengthInBits();
        lengthInBits += this.requestorId.getLengthInBits();
        lengthInBits += 64;
        lengthInBits += 32;
        if (this.messages != null) {
            int i = 0;
            for (ExtensionObject element : this.messages) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.messages.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("JsonActionNetworkMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString messageId = (PascalString)FieldReaderFactory.readSimpleField((String)"messageId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString messageType = (PascalString)FieldReaderFactory.readSimpleField((String)"messageType", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString publisherId = (PascalString)FieldReaderFactory.readSimpleField((String)"publisherId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long timestamp = (Long)FieldReaderFactory.readSimpleField((String)"timestamp", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString responseAddress = (PascalString)FieldReaderFactory.readSimpleField((String)"responseAddress", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalByteString correlationData = (PascalByteString)FieldReaderFactory.readSimpleField((String)"correlationData", (DataReader)DataReaderFactory.readComplex(() -> PascalByteString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString requestorId = (PascalString)FieldReaderFactory.readSimpleField((String)"requestorId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        double timeoutHint = (Double)FieldReaderFactory.readSimpleField((String)"timeoutHint", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfMessages = (Integer)FieldReaderFactory.readImplicitField((String)"noOfMessages", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List messages = FieldReaderFactory.readCountArrayField((String)"messages", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (long)noOfMessages, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("JsonActionNetworkMessage", new WithReaderArgs[0]);
        return new JsonActionNetworkMessageBuilderImpl(messageId, messageType, publisherId, timestamp, responseAddress, correlationData, requestorId, timeoutHint, messages);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonActionNetworkMessage)) {
            return false;
        }
        JsonActionNetworkMessage that = (JsonActionNetworkMessage)o;
        return this.getMessageId() == that.getMessageId() && this.getMessageType() == that.getMessageType() && this.getPublisherId() == that.getPublisherId() && this.getTimestamp() == that.getTimestamp() && this.getResponseAddress() == that.getResponseAddress() && this.getCorrelationData() == that.getCorrelationData() && this.getRequestorId() == that.getRequestorId() && this.getTimeoutHint() == that.getTimeoutHint() && this.getMessages() == that.getMessages() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMessageId(), this.getMessageType(), this.getPublisherId(), this.getTimestamp(), this.getResponseAddress(), this.getCorrelationData(), this.getRequestorId(), this.getTimeoutHint(), this.getMessages());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class JsonActionNetworkMessageBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString messageId;
        private final PascalString messageType;
        private final PascalString publisherId;
        private final long timestamp;
        private final PascalString responseAddress;
        private final PascalByteString correlationData;
        private final PascalString requestorId;
        private final double timeoutHint;
        private final List<ExtensionObject> messages;

        public JsonActionNetworkMessageBuilderImpl(PascalString messageId, PascalString messageType, PascalString publisherId, long timestamp, PascalString responseAddress, PascalByteString correlationData, PascalString requestorId, double timeoutHint, List<ExtensionObject> messages) {
            this.messageId = messageId;
            this.messageType = messageType;
            this.publisherId = publisherId;
            this.timestamp = timestamp;
            this.responseAddress = responseAddress;
            this.correlationData = correlationData;
            this.requestorId = requestorId;
            this.timeoutHint = timeoutHint;
            this.messages = messages;
        }

        @Override
        public JsonActionNetworkMessage build() {
            JsonActionNetworkMessage jsonActionNetworkMessage = new JsonActionNetworkMessage(this.messageId, this.messageType, this.publisherId, this.timestamp, this.responseAddress, this.correlationData, this.requestorId, this.timeoutHint, this.messages);
            return jsonActionNetworkMessage;
        }
    }
}

