/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.NameValuePair;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.TraceContextDataType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class LogRecord
extends ExtensionObjectDefinition
implements Message {
    protected final long eventTime;
    protected final int severity;
    protected final NodeId eventType;
    protected final NodeId sourceNode;
    protected final PascalString sourceName;
    protected final LocalizedText message;
    protected final TraceContextDataType traceContext;
    protected final List<NameValuePair> additionalData;

    @Override
    public Integer getExtensionId() {
        return 19363;
    }

    public LogRecord(long eventTime, int severity, NodeId eventType, NodeId sourceNode, PascalString sourceName, LocalizedText message, TraceContextDataType traceContext, List<NameValuePair> additionalData) {
        this.eventTime = eventTime;
        this.severity = severity;
        this.eventType = eventType;
        this.sourceNode = sourceNode;
        this.sourceName = sourceName;
        this.message = message;
        this.traceContext = traceContext;
        this.additionalData = additionalData;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public int getSeverity() {
        return this.severity;
    }

    public NodeId getEventType() {
        return this.eventType;
    }

    public NodeId getSourceNode() {
        return this.sourceNode;
    }

    public PascalString getSourceName() {
        return this.sourceName;
    }

    public LocalizedText getMessage() {
        return this.message;
    }

    public TraceContextDataType getTraceContext() {
        return this.traceContext;
    }

    public List<NameValuePair> getAdditionalData() {
        return this.additionalData;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("LogRecord", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"eventTime", (Object)this.eventTime, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"severity", (Object)this.severity, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"eventType", (Object)this.eventType, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sourceNode", (Object)this.sourceNode, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sourceName", (Object)this.sourceName, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"message", (Object)this.message, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"traceContext", (Object)this.traceContext, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfAdditionalData = this.getAdditionalData() == null ? -1 : StaticHelper.COUNT(this.getAdditionalData());
        FieldWriterFactory.writeImplicitField((String)"noOfAdditionalData", (Object)noOfAdditionalData, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"additionalData", this.additionalData, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("LogRecord", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        LogRecord _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 64;
        lengthInBits += 16;
        lengthInBits += this.eventType.getLengthInBits();
        lengthInBits += this.sourceNode.getLengthInBits();
        lengthInBits += this.sourceName.getLengthInBits();
        lengthInBits += this.message.getLengthInBits();
        lengthInBits += this.traceContext.getLengthInBits();
        lengthInBits += 32;
        if (this.additionalData != null) {
            int i = 0;
            for (NameValuePair element : this.additionalData) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.additionalData.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("LogRecord", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long eventTime = (Long)FieldReaderFactory.readSimpleField((String)"eventTime", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        int severity = (Integer)FieldReaderFactory.readSimpleField((String)"severity", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId eventType = (NodeId)FieldReaderFactory.readSimpleField((String)"eventType", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId sourceNode = (NodeId)FieldReaderFactory.readSimpleField((String)"sourceNode", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString sourceName = (PascalString)FieldReaderFactory.readSimpleField((String)"sourceName", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        LocalizedText message = (LocalizedText)FieldReaderFactory.readSimpleField((String)"message", (DataReader)DataReaderFactory.readComplex(() -> LocalizedText.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        TraceContextDataType traceContext = (TraceContextDataType)FieldReaderFactory.readSimpleField((String)"traceContext", (DataReader)DataReaderFactory.readComplex(() -> (TraceContextDataType)ExtensionObjectDefinition.staticParse(readBuffer, 19749), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfAdditionalData = (Integer)FieldReaderFactory.readImplicitField((String)"noOfAdditionalData", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List additionalData = FieldReaderFactory.readCountArrayField((String)"additionalData", (DataReader)DataReaderFactory.readComplex(() -> (NameValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 19750), (ReadBuffer)readBuffer), (long)noOfAdditionalData, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("LogRecord", new WithReaderArgs[0]);
        return new LogRecordBuilderImpl(eventTime, severity, eventType, sourceNode, sourceName, message, traceContext, additionalData);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogRecord)) {
            return false;
        }
        LogRecord that = (LogRecord)o;
        return this.getEventTime() == that.getEventTime() && this.getSeverity() == that.getSeverity() && this.getEventType() == that.getEventType() && this.getSourceNode() == that.getSourceNode() && this.getSourceName() == that.getSourceName() && this.getMessage() == that.getMessage() && this.getTraceContext() == that.getTraceContext() && this.getAdditionalData() == that.getAdditionalData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEventTime(), this.getSeverity(), this.getEventType(), this.getSourceNode(), this.getSourceName(), this.getMessage(), this.getTraceContext(), this.getAdditionalData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class LogRecordBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long eventTime;
        private final int severity;
        private final NodeId eventType;
        private final NodeId sourceNode;
        private final PascalString sourceName;
        private final LocalizedText message;
        private final TraceContextDataType traceContext;
        private final List<NameValuePair> additionalData;

        public LogRecordBuilderImpl(long eventTime, int severity, NodeId eventType, NodeId sourceNode, PascalString sourceName, LocalizedText message, TraceContextDataType traceContext, List<NameValuePair> additionalData) {
            this.eventTime = eventTime;
            this.severity = severity;
            this.eventType = eventType;
            this.sourceNode = sourceNode;
            this.sourceName = sourceName;
            this.message = message;
            this.traceContext = traceContext;
            this.additionalData = additionalData;
        }

        @Override
        public LogRecord build() {
            LogRecord logRecord = new LogRecord(this.eventTime, this.severity, this.eventType, this.sourceNode, this.sourceName, this.message, this.traceContext, this.additionalData);
            return logRecord;
        }
    }
}

