/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.Payload;
import org.apache.plc4x.java.opcua.readwrite.SecurityHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaMessageResponse
extends MessagePDU
implements Message {
    protected final SecurityHeader securityHeader;
    protected final Payload message;

    @Override
    public String getMessageType() {
        return "MSG";
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    public OpcuaMessageResponse(ChunkType chunk, SecurityHeader securityHeader, Payload message) {
        super(chunk);
        this.securityHeader = securityHeader;
        this.message = message;
    }

    public SecurityHeader getSecurityHeader() {
        return this.securityHeader;
    }

    public Payload getMessage() {
        return this.message;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaMessageResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"securityHeader", (Object)this.securityHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"message", (Object)this.message, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaMessageResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaMessageResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.securityHeader.getLengthInBits();
        return lengthInBits += this.message.getLengthInBits();
    }

    public static MessagePDU.MessagePDUBuilder staticParseMessagePDUBuilder(ReadBuffer readBuffer, Long totalLength, Boolean response, Boolean binary) throws ParseException {
        readBuffer.pullContext("OpcuaMessageResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        SecurityHeader securityHeader = (SecurityHeader)FieldReaderFactory.readSimpleField((String)"securityHeader", (DataReader)DataReaderFactory.readComplex(() -> SecurityHeader.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Payload message = (Payload)FieldReaderFactory.readSimpleField((String)"message", (DataReader)DataReaderFactory.readComplex(() -> Payload.staticParse(readBuffer, (boolean)binary, totalLength - (long)securityHeader.getLengthInBytes() - 16L), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaMessageResponse", new WithReaderArgs[0]);
        return new OpcuaMessageResponseBuilderImpl(securityHeader, message);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaMessageResponse)) {
            return false;
        }
        OpcuaMessageResponse that = (OpcuaMessageResponse)o;
        return this.getSecurityHeader() == that.getSecurityHeader() && this.getMessage() == that.getMessage() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSecurityHeader(), this.getMessage());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaMessageResponseBuilderImpl
    implements MessagePDU.MessagePDUBuilder {
        private final SecurityHeader securityHeader;
        private final Payload message;

        public OpcuaMessageResponseBuilderImpl(SecurityHeader securityHeader, Payload message) {
            this.securityHeader = securityHeader;
            this.message = message;
        }

        @Override
        public OpcuaMessageResponse build(ChunkType chunk) {
            OpcuaMessageResponse opcuaMessageResponse = new OpcuaMessageResponse(chunk, this.securityHeader, this.message);
            return opcuaMessageResponse;
        }
    }
}

