/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.OpenChannelMessage;
import org.apache.plc4x.java.opcua.readwrite.Payload;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaOpenRequest
extends MessagePDU
implements Message {
    protected final OpenChannelMessage openRequest;
    protected final Payload message;

    @Override
    public String getMessageType() {
        return "OPN";
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public OpcuaOpenRequest(ChunkType chunk, OpenChannelMessage openRequest, Payload message) {
        super(chunk);
        this.openRequest = openRequest;
        this.message = message;
    }

    public OpenChannelMessage getOpenRequest() {
        return this.openRequest;
    }

    public Payload getMessage() {
        return this.message;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaOpenRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"openRequest", (Object)this.openRequest, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"message", (Object)this.message, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaOpenRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaOpenRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.openRequest.getLengthInBits();
        return lengthInBits += this.message.getLengthInBits();
    }

    public static MessagePDU.MessagePDUBuilder staticParseMessagePDUBuilder(ReadBuffer readBuffer, Long totalLength, Boolean response, Boolean binary) throws ParseException {
        readBuffer.pullContext("OpcuaOpenRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        OpenChannelMessage openRequest = (OpenChannelMessage)FieldReaderFactory.readSimpleField((String)"openRequest", (DataReader)DataReaderFactory.readComplex(() -> OpenChannelMessage.staticParse(readBuffer, (boolean)response), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Payload message = (Payload)FieldReaderFactory.readSimpleField((String)"message", (DataReader)DataReaderFactory.readComplex(() -> Payload.staticParse(readBuffer, (boolean)binary, totalLength - (long)openRequest.getLengthInBytes() - 16L), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaOpenRequest", new WithReaderArgs[0]);
        return new OpcuaOpenRequestBuilderImpl(openRequest, message);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaOpenRequest)) {
            return false;
        }
        OpcuaOpenRequest that = (OpcuaOpenRequest)o;
        return this.getOpenRequest() == that.getOpenRequest() && this.getMessage() == that.getMessage() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getOpenRequest(), this.getMessage());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaOpenRequestBuilderImpl
    implements MessagePDU.MessagePDUBuilder {
        private final OpenChannelMessage openRequest;
        private final Payload message;

        public OpcuaOpenRequestBuilderImpl(OpenChannelMessage openRequest, Payload message) {
            this.openRequest = openRequest;
            this.message = message;
        }

        @Override
        public OpcuaOpenRequest build(ChunkType chunk) {
            OpcuaOpenRequest opcuaOpenRequest = new OpcuaOpenRequest(chunk, this.openRequest, this.message);
            return opcuaOpenRequest;
        }
    }
}

