/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.SecurityTokenRequestType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpenSecureChannelRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final long clientProtocolVersion;
    protected final SecurityTokenRequestType requestType;
    protected final MessageSecurityMode securityMode;
    protected final PascalByteString clientNonce;
    protected final long requestedLifetime;

    @Override
    public Integer getExtensionId() {
        return 446;
    }

    public OpenSecureChannelRequest(RequestHeader requestHeader, long clientProtocolVersion, SecurityTokenRequestType requestType, MessageSecurityMode securityMode, PascalByteString clientNonce, long requestedLifetime) {
        this.requestHeader = requestHeader;
        this.clientProtocolVersion = clientProtocolVersion;
        this.requestType = requestType;
        this.securityMode = securityMode;
        this.clientNonce = clientNonce;
        this.requestedLifetime = requestedLifetime;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public long getClientProtocolVersion() {
        return this.clientProtocolVersion;
    }

    public SecurityTokenRequestType getRequestType() {
        return this.requestType;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public PascalByteString getClientNonce() {
        return this.clientNonce;
    }

    public long getRequestedLifetime() {
        return this.requestedLifetime;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpenSecureChannelRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"clientProtocolVersion", (Object)this.clientProtocolVersion, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"requestType", (String)"SecurityTokenRequestType", (Object)((Object)this.requestType), (DataWriter)DataWriterFactory.writeEnum(SecurityTokenRequestType::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"securityMode", (String)"MessageSecurityMode", (Object)((Object)this.securityMode), (DataWriter)DataWriterFactory.writeEnum(MessageSecurityMode::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"clientNonce", (Object)this.clientNonce, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestedLifetime", (Object)this.requestedLifetime, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpenSecureChannelRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpenSecureChannelRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += this.clientNonce.getLengthInBits();
        return lengthInBits += 32;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("OpenSecureChannelRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long clientProtocolVersion = (Long)FieldReaderFactory.readSimpleField((String)"clientProtocolVersion", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        SecurityTokenRequestType requestType = (SecurityTokenRequestType)((Object)FieldReaderFactory.readEnumField((String)"requestType", (String)"SecurityTokenRequestType", (DataReader)DataReaderFactory.readEnum(SecurityTokenRequestType::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        MessageSecurityMode securityMode = (MessageSecurityMode)((Object)FieldReaderFactory.readEnumField((String)"securityMode", (String)"MessageSecurityMode", (DataReader)DataReaderFactory.readEnum(MessageSecurityMode::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        PascalByteString clientNonce = (PascalByteString)FieldReaderFactory.readSimpleField((String)"clientNonce", (DataReader)DataReaderFactory.readComplex(() -> PascalByteString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long requestedLifetime = (Long)FieldReaderFactory.readSimpleField((String)"requestedLifetime", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpenSecureChannelRequest", new WithReaderArgs[0]);
        return new OpenSecureChannelRequestBuilderImpl(requestHeader, clientProtocolVersion, requestType, securityMode, clientNonce, requestedLifetime);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenSecureChannelRequest)) {
            return false;
        }
        OpenSecureChannelRequest that = (OpenSecureChannelRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getClientProtocolVersion() == that.getClientProtocolVersion() && this.getRequestType() == that.getRequestType() && this.getSecurityMode() == that.getSecurityMode() && this.getClientNonce() == that.getClientNonce() && this.getRequestedLifetime() == that.getRequestedLifetime() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getRequestHeader(), this.getClientProtocolVersion(), this.getRequestType(), this.getSecurityMode(), this.getClientNonce(), this.getRequestedLifetime()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpenSecureChannelRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final long clientProtocolVersion;
        private final SecurityTokenRequestType requestType;
        private final MessageSecurityMode securityMode;
        private final PascalByteString clientNonce;
        private final long requestedLifetime;

        public OpenSecureChannelRequestBuilderImpl(RequestHeader requestHeader, long clientProtocolVersion, SecurityTokenRequestType requestType, MessageSecurityMode securityMode, PascalByteString clientNonce, long requestedLifetime) {
            this.requestHeader = requestHeader;
            this.clientProtocolVersion = clientProtocolVersion;
            this.requestType = requestType;
            this.securityMode = securityMode;
            this.clientNonce = clientNonce;
            this.requestedLifetime = requestedLifetime;
        }

        @Override
        public OpenSecureChannelRequest build() {
            OpenSecureChannelRequest openSecureChannelRequest = new OpenSecureChannelRequest(this.requestHeader, this.clientProtocolVersion, this.requestType, this.securityMode, this.clientNonce, this.requestedLifetime);
            return openSecureChannelRequest;
        }
    }
}

