/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ActionMethodDataType;
import org.apache.plc4x.java.opcua.readwrite.ActionTargetDataType;
import org.apache.plc4x.java.opcua.readwrite.DataSetMetaDataType;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class PublishedActionMethodDataType
extends ExtensionObjectDefinition
implements Message {
    protected final DataSetMetaDataType requestDataSetMetaData;
    protected final List<ActionTargetDataType> actionTargets;
    protected final List<ActionMethodDataType> actionMethods;

    @Override
    public Integer getExtensionId() {
        return 18795;
    }

    public PublishedActionMethodDataType(DataSetMetaDataType requestDataSetMetaData, List<ActionTargetDataType> actionTargets, List<ActionMethodDataType> actionMethods) {
        this.requestDataSetMetaData = requestDataSetMetaData;
        this.actionTargets = actionTargets;
        this.actionMethods = actionMethods;
    }

    public DataSetMetaDataType getRequestDataSetMetaData() {
        return this.requestDataSetMetaData;
    }

    public List<ActionTargetDataType> getActionTargets() {
        return this.actionTargets;
    }

    public List<ActionMethodDataType> getActionMethods() {
        return this.actionMethods;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("PublishedActionMethodDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestDataSetMetaData", (Object)this.requestDataSetMetaData, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfActionTargets = this.getActionTargets() == null ? -1 : StaticHelper.COUNT(this.getActionTargets());
        FieldWriterFactory.writeImplicitField((String)"noOfActionTargets", (Object)noOfActionTargets, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"actionTargets", this.actionTargets, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfActionMethods = this.getActionMethods() == null ? -1 : StaticHelper.COUNT(this.getActionMethods());
        FieldWriterFactory.writeImplicitField((String)"noOfActionMethods", (Object)noOfActionMethods, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"actionMethods", this.actionMethods, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("PublishedActionMethodDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        PublishedActionMethodDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestDataSetMetaData.getLengthInBits();
        lengthInBits += 32;
        if (this.actionTargets != null) {
            i = 0;
            for (ActionTargetDataType actionTargetDataType : this.actionTargets) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.actionTargets.size());
                lengthInBits += actionTargetDataType.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.actionMethods != null) {
            i = 0;
            for (ActionMethodDataType actionMethodDataType : this.actionMethods) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.actionMethods.size());
                lengthInBits += actionMethodDataType.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("PublishedActionMethodDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        DataSetMetaDataType requestDataSetMetaData = (DataSetMetaDataType)FieldReaderFactory.readSimpleField((String)"requestDataSetMetaData", (DataReader)DataReaderFactory.readComplex(() -> (DataSetMetaDataType)ExtensionObjectDefinition.staticParse(readBuffer, 14525), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfActionTargets = (Integer)FieldReaderFactory.readImplicitField((String)"noOfActionTargets", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List actionTargets = FieldReaderFactory.readCountArrayField((String)"actionTargets", (DataReader)DataReaderFactory.readComplex(() -> (ActionTargetDataType)ExtensionObjectDefinition.staticParse(readBuffer, 18595), (ReadBuffer)readBuffer), (long)noOfActionTargets, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfActionMethods = (Integer)FieldReaderFactory.readImplicitField((String)"noOfActionMethods", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List actionMethods = FieldReaderFactory.readCountArrayField((String)"actionMethods", (DataReader)DataReaderFactory.readComplex(() -> (ActionMethodDataType)ExtensionObjectDefinition.staticParse(readBuffer, 18599), (ReadBuffer)readBuffer), (long)noOfActionMethods, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("PublishedActionMethodDataType", new WithReaderArgs[0]);
        return new PublishedActionMethodDataTypeBuilderImpl(requestDataSetMetaData, actionTargets, actionMethods);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishedActionMethodDataType)) {
            return false;
        }
        PublishedActionMethodDataType that = (PublishedActionMethodDataType)o;
        return this.getRequestDataSetMetaData() == that.getRequestDataSetMetaData() && this.getActionTargets() == that.getActionTargets() && this.getActionMethods() == that.getActionMethods() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestDataSetMetaData(), this.getActionTargets(), this.getActionMethods());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class PublishedActionMethodDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final DataSetMetaDataType requestDataSetMetaData;
        private final List<ActionTargetDataType> actionTargets;
        private final List<ActionMethodDataType> actionMethods;

        public PublishedActionMethodDataTypeBuilderImpl(DataSetMetaDataType requestDataSetMetaData, List<ActionTargetDataType> actionTargets, List<ActionMethodDataType> actionMethods) {
            this.requestDataSetMetaData = requestDataSetMetaData;
            this.actionTargets = actionTargets;
            this.actionMethods = actionMethods;
        }

        @Override
        public PublishedActionMethodDataType build() {
            PublishedActionMethodDataType publishedActionMethodDataType = new PublishedActionMethodDataType(this.requestDataSetMetaData, this.actionTargets, this.actionMethods);
            return publishedActionMethodDataType;
        }
    }
}

