/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ContentFilterResult;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ParsingResult;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.QueryDataSet;
import org.apache.plc4x.java.opcua.readwrite.ResponseHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class QueryFirstResponse
extends ExtensionObjectDefinition
implements Message {
    protected final ResponseHeader responseHeader;
    protected final List<QueryDataSet> queryDataSets;
    protected final PascalByteString continuationPoint;
    protected final List<ParsingResult> parsingResults;
    protected final List<DiagnosticInfo> diagnosticInfos;
    protected final ContentFilterResult filterResult;

    @Override
    public Integer getExtensionId() {
        return 618;
    }

    public QueryFirstResponse(ResponseHeader responseHeader, List<QueryDataSet> queryDataSets, PascalByteString continuationPoint, List<ParsingResult> parsingResults, List<DiagnosticInfo> diagnosticInfos, ContentFilterResult filterResult) {
        this.responseHeader = responseHeader;
        this.queryDataSets = queryDataSets;
        this.continuationPoint = continuationPoint;
        this.parsingResults = parsingResults;
        this.diagnosticInfos = diagnosticInfos;
        this.filterResult = filterResult;
    }

    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public List<QueryDataSet> getQueryDataSets() {
        return this.queryDataSets;
    }

    public PascalByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public List<ParsingResult> getParsingResults() {
        return this.parsingResults;
    }

    public List<DiagnosticInfo> getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    public ContentFilterResult getFilterResult() {
        return this.filterResult;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("QueryFirstResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"responseHeader", (Object)this.responseHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfQueryDataSets = this.getQueryDataSets() == null ? -1 : StaticHelper.COUNT(this.getQueryDataSets());
        FieldWriterFactory.writeImplicitField((String)"noOfQueryDataSets", (Object)noOfQueryDataSets, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"queryDataSets", this.queryDataSets, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"continuationPoint", (Object)this.continuationPoint, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfParsingResults = this.getParsingResults() == null ? -1 : StaticHelper.COUNT(this.getParsingResults());
        FieldWriterFactory.writeImplicitField((String)"noOfParsingResults", (Object)noOfParsingResults, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"parsingResults", this.parsingResults, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDiagnosticInfos = this.getDiagnosticInfos() == null ? -1 : StaticHelper.COUNT(this.getDiagnosticInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfDiagnosticInfos", (Object)noOfDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"diagnosticInfos", this.diagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"filterResult", (Object)this.filterResult, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("QueryFirstResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        QueryFirstResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.responseHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.queryDataSets != null) {
            i = 0;
            for (QueryDataSet queryDataSet : this.queryDataSets) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.queryDataSets.size());
                lengthInBits += queryDataSet.getLengthInBits();
            }
        }
        lengthInBits += this.continuationPoint.getLengthInBits();
        lengthInBits += 32;
        if (this.parsingResults != null) {
            i = 0;
            for (ParsingResult parsingResult : this.parsingResults) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.parsingResults.size());
                lengthInBits += parsingResult.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.diagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.diagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.diagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits += this.filterResult.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("QueryFirstResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ResponseHeader responseHeader = (ResponseHeader)FieldReaderFactory.readSimpleField((String)"responseHeader", (DataReader)DataReaderFactory.readComplex(() -> (ResponseHeader)ExtensionObjectDefinition.staticParse(readBuffer, 394), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfQueryDataSets = (Integer)FieldReaderFactory.readImplicitField((String)"noOfQueryDataSets", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List queryDataSets = FieldReaderFactory.readCountArrayField((String)"queryDataSets", (DataReader)DataReaderFactory.readComplex(() -> (QueryDataSet)ExtensionObjectDefinition.staticParse(readBuffer, 579), (ReadBuffer)readBuffer), (long)noOfQueryDataSets, (WithReaderArgs[])new WithReaderArgs[0]);
        PascalByteString continuationPoint = (PascalByteString)FieldReaderFactory.readSimpleField((String)"continuationPoint", (DataReader)DataReaderFactory.readComplex(() -> PascalByteString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfParsingResults = (Integer)FieldReaderFactory.readImplicitField((String)"noOfParsingResults", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List parsingResults = FieldReaderFactory.readCountArrayField((String)"parsingResults", (DataReader)DataReaderFactory.readComplex(() -> (ParsingResult)ExtensionObjectDefinition.staticParse(readBuffer, 612), (ReadBuffer)readBuffer), (long)noOfParsingResults, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDiagnosticInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List diagnosticInfos = FieldReaderFactory.readCountArrayField((String)"diagnosticInfos", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        ContentFilterResult filterResult = (ContentFilterResult)FieldReaderFactory.readSimpleField((String)"filterResult", (DataReader)DataReaderFactory.readComplex(() -> (ContentFilterResult)ExtensionObjectDefinition.staticParse(readBuffer, 609), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("QueryFirstResponse", new WithReaderArgs[0]);
        return new QueryFirstResponseBuilderImpl(responseHeader, queryDataSets, continuationPoint, parsingResults, diagnosticInfos, filterResult);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryFirstResponse)) {
            return false;
        }
        QueryFirstResponse that = (QueryFirstResponse)o;
        return this.getResponseHeader() == that.getResponseHeader() && this.getQueryDataSets() == that.getQueryDataSets() && this.getContinuationPoint() == that.getContinuationPoint() && this.getParsingResults() == that.getParsingResults() && this.getDiagnosticInfos() == that.getDiagnosticInfos() && this.getFilterResult() == that.getFilterResult() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseHeader(), this.getQueryDataSets(), this.getContinuationPoint(), this.getParsingResults(), this.getDiagnosticInfos(), this.getFilterResult());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class QueryFirstResponseBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ResponseHeader responseHeader;
        private final List<QueryDataSet> queryDataSets;
        private final PascalByteString continuationPoint;
        private final List<ParsingResult> parsingResults;
        private final List<DiagnosticInfo> diagnosticInfos;
        private final ContentFilterResult filterResult;

        public QueryFirstResponseBuilderImpl(ResponseHeader responseHeader, List<QueryDataSet> queryDataSets, PascalByteString continuationPoint, List<ParsingResult> parsingResults, List<DiagnosticInfo> diagnosticInfos, ContentFilterResult filterResult) {
            this.responseHeader = responseHeader;
            this.queryDataSets = queryDataSets;
            this.continuationPoint = continuationPoint;
            this.parsingResults = parsingResults;
            this.diagnosticInfos = diagnosticInfos;
            this.filterResult = filterResult;
        }

        @Override
        public QueryFirstResponse build() {
            QueryFirstResponse queryFirstResponse = new QueryFirstResponse(this.responseHeader, this.queryDataSets, this.continuationPoint, this.parsingResults, this.diagnosticInfos, this.filterResult);
            return queryFirstResponse;
        }
    }
}

