/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataSetReaderDataType;
import org.apache.plc4x.java.opcua.readwrite.EndpointDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ReaderGroupDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final boolean enabled;
    protected final MessageSecurityMode securityMode;
    protected final PascalString securityGroupId;
    protected final List<EndpointDescription> securityKeyServices;
    protected final long maxNetworkMessageSize;
    protected final List<KeyValuePair> groupProperties;
    protected final ExtensionObject transportSettings;
    protected final ExtensionObject messageSettings;
    protected final List<DataSetReaderDataType> dataSetReaders;

    @Override
    public Integer getExtensionId() {
        return 15522;
    }

    public ReaderGroupDataType(PascalString name, boolean enabled, MessageSecurityMode securityMode, PascalString securityGroupId, List<EndpointDescription> securityKeyServices, long maxNetworkMessageSize, List<KeyValuePair> groupProperties, ExtensionObject transportSettings, ExtensionObject messageSettings, List<DataSetReaderDataType> dataSetReaders) {
        this.name = name;
        this.enabled = enabled;
        this.securityMode = securityMode;
        this.securityGroupId = securityGroupId;
        this.securityKeyServices = securityKeyServices;
        this.maxNetworkMessageSize = maxNetworkMessageSize;
        this.groupProperties = groupProperties;
        this.transportSettings = transportSettings;
        this.messageSettings = messageSettings;
        this.dataSetReaders = dataSetReaders;
    }

    public PascalString getName() {
        return this.name;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public PascalString getSecurityGroupId() {
        return this.securityGroupId;
    }

    public List<EndpointDescription> getSecurityKeyServices() {
        return this.securityKeyServices;
    }

    public long getMaxNetworkMessageSize() {
        return this.maxNetworkMessageSize;
    }

    public List<KeyValuePair> getGroupProperties() {
        return this.groupProperties;
    }

    public ExtensionObject getTransportSettings() {
        return this.transportSettings;
    }

    public ExtensionObject getMessageSettings() {
        return this.messageSettings;
    }

    public List<DataSetReaderDataType> getDataSetReaders() {
        return this.dataSetReaders;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ReaderGroupDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"enabled", (Object)this.enabled, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"securityMode", (String)"MessageSecurityMode", (Object)((Object)this.securityMode), (DataWriter)DataWriterFactory.writeEnum(MessageSecurityMode::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"securityGroupId", (Object)this.securityGroupId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSecurityKeyServices = this.getSecurityKeyServices() == null ? -1 : StaticHelper.COUNT(this.getSecurityKeyServices());
        FieldWriterFactory.writeImplicitField((String)"noOfSecurityKeyServices", (Object)noOfSecurityKeyServices, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"securityKeyServices", this.securityKeyServices, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxNetworkMessageSize", (Object)this.maxNetworkMessageSize, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfGroupProperties = this.getGroupProperties() == null ? -1 : StaticHelper.COUNT(this.getGroupProperties());
        FieldWriterFactory.writeImplicitField((String)"noOfGroupProperties", (Object)noOfGroupProperties, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"groupProperties", this.groupProperties, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"transportSettings", (Object)this.transportSettings, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageSettings", (Object)this.messageSettings, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDataSetReaders = this.getDataSetReaders() == null ? -1 : StaticHelper.COUNT(this.getDataSetReaders());
        FieldWriterFactory.writeImplicitField((String)"noOfDataSetReaders", (Object)noOfDataSetReaders, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"dataSetReaders", this.dataSetReaders, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ReaderGroupDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        ReaderGroupDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += 32;
        lengthInBits += this.securityGroupId.getLengthInBits();
        lengthInBits += 32;
        if (this.securityKeyServices != null) {
            i = 0;
            for (EndpointDescription endpointDescription : this.securityKeyServices) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.securityKeyServices.size());
                lengthInBits += endpointDescription.getLengthInBits();
            }
        }
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.groupProperties != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.groupProperties) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.groupProperties.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        lengthInBits += this.transportSettings.getLengthInBits();
        lengthInBits += this.messageSettings.getLengthInBits();
        lengthInBits += 32;
        if (this.dataSetReaders != null) {
            i = 0;
            for (DataSetReaderDataType dataSetReaderDataType : this.dataSetReaders) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataSetReaders.size());
                lengthInBits += dataSetReaderDataType.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ReaderGroupDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean enabled = (Boolean)FieldReaderFactory.readSimpleField((String)"enabled", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        MessageSecurityMode securityMode = (MessageSecurityMode)((Object)FieldReaderFactory.readEnumField((String)"securityMode", (String)"MessageSecurityMode", (DataReader)DataReaderFactory.readEnum(MessageSecurityMode::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        PascalString securityGroupId = (PascalString)FieldReaderFactory.readSimpleField((String)"securityGroupId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSecurityKeyServices = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSecurityKeyServices", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List securityKeyServices = FieldReaderFactory.readCountArrayField((String)"securityKeyServices", (DataReader)DataReaderFactory.readComplex(() -> (EndpointDescription)ExtensionObjectDefinition.staticParse(readBuffer, 314), (ReadBuffer)readBuffer), (long)noOfSecurityKeyServices, (WithReaderArgs[])new WithReaderArgs[0]);
        long maxNetworkMessageSize = (Long)FieldReaderFactory.readSimpleField((String)"maxNetworkMessageSize", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfGroupProperties = (Integer)FieldReaderFactory.readImplicitField((String)"noOfGroupProperties", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List groupProperties = FieldReaderFactory.readCountArrayField((String)"groupProperties", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfGroupProperties, (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject transportSettings = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"transportSettings", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject messageSettings = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"messageSettings", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDataSetReaders = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDataSetReaders", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List dataSetReaders = FieldReaderFactory.readCountArrayField((String)"dataSetReaders", (DataReader)DataReaderFactory.readComplex(() -> (DataSetReaderDataType)ExtensionObjectDefinition.staticParse(readBuffer, 15625), (ReadBuffer)readBuffer), (long)noOfDataSetReaders, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ReaderGroupDataType", new WithReaderArgs[0]);
        return new ReaderGroupDataTypeBuilderImpl(name, enabled, securityMode, securityGroupId, securityKeyServices, maxNetworkMessageSize, groupProperties, transportSettings, messageSettings, dataSetReaders);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReaderGroupDataType)) {
            return false;
        }
        ReaderGroupDataType that = (ReaderGroupDataType)o;
        return this.getName() == that.getName() && this.getEnabled() == that.getEnabled() && this.getSecurityMode() == that.getSecurityMode() && this.getSecurityGroupId() == that.getSecurityGroupId() && this.getSecurityKeyServices() == that.getSecurityKeyServices() && this.getMaxNetworkMessageSize() == that.getMaxNetworkMessageSize() && this.getGroupProperties() == that.getGroupProperties() && this.getTransportSettings() == that.getTransportSettings() && this.getMessageSettings() == that.getMessageSettings() && this.getDataSetReaders() == that.getDataSetReaders() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getName(), this.getEnabled(), this.getSecurityMode(), this.getSecurityGroupId(), this.getSecurityKeyServices(), this.getMaxNetworkMessageSize(), this.getGroupProperties(), this.getTransportSettings(), this.getMessageSettings(), this.getDataSetReaders()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ReaderGroupDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final boolean enabled;
        private final MessageSecurityMode securityMode;
        private final PascalString securityGroupId;
        private final List<EndpointDescription> securityKeyServices;
        private final long maxNetworkMessageSize;
        private final List<KeyValuePair> groupProperties;
        private final ExtensionObject transportSettings;
        private final ExtensionObject messageSettings;
        private final List<DataSetReaderDataType> dataSetReaders;

        public ReaderGroupDataTypeBuilderImpl(PascalString name, boolean enabled, MessageSecurityMode securityMode, PascalString securityGroupId, List<EndpointDescription> securityKeyServices, long maxNetworkMessageSize, List<KeyValuePair> groupProperties, ExtensionObject transportSettings, ExtensionObject messageSettings, List<DataSetReaderDataType> dataSetReaders) {
            this.name = name;
            this.enabled = enabled;
            this.securityMode = securityMode;
            this.securityGroupId = securityGroupId;
            this.securityKeyServices = securityKeyServices;
            this.maxNetworkMessageSize = maxNetworkMessageSize;
            this.groupProperties = groupProperties;
            this.transportSettings = transportSettings;
            this.messageSettings = messageSettings;
            this.dataSetReaders = dataSetReaders;
        }

        @Override
        public ReaderGroupDataType build() {
            ReaderGroupDataType readerGroupDataType = new ReaderGroupDataType(this.name, this.enabled, this.securityMode, this.securityGroupId, this.securityKeyServices, this.maxNetworkMessageSize, this.groupProperties, this.transportSettings, this.messageSettings, this.dataSetReaders);
            return readerGroupDataType;
        }
    }
}

