/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.ResponseHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class RegisterNodesResponse
extends ExtensionObjectDefinition
implements Message {
    protected final ResponseHeader responseHeader;
    protected final List<NodeId> registeredNodeIds;

    @Override
    public Integer getExtensionId() {
        return 563;
    }

    public RegisterNodesResponse(ResponseHeader responseHeader, List<NodeId> registeredNodeIds) {
        this.responseHeader = responseHeader;
        this.registeredNodeIds = registeredNodeIds;
    }

    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public List<NodeId> getRegisteredNodeIds() {
        return this.registeredNodeIds;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("RegisterNodesResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"responseHeader", (Object)this.responseHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfRegisteredNodeIds = this.getRegisteredNodeIds() == null ? -1 : StaticHelper.COUNT(this.getRegisteredNodeIds());
        FieldWriterFactory.writeImplicitField((String)"noOfRegisteredNodeIds", (Object)noOfRegisteredNodeIds, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"registeredNodeIds", this.registeredNodeIds, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("RegisterNodesResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        RegisterNodesResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.responseHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.registeredNodeIds != null) {
            int i = 0;
            for (NodeId element : this.registeredNodeIds) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.registeredNodeIds.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("RegisterNodesResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ResponseHeader responseHeader = (ResponseHeader)FieldReaderFactory.readSimpleField((String)"responseHeader", (DataReader)DataReaderFactory.readComplex(() -> (ResponseHeader)ExtensionObjectDefinition.staticParse(readBuffer, 394), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfRegisteredNodeIds = (Integer)FieldReaderFactory.readImplicitField((String)"noOfRegisteredNodeIds", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List registeredNodeIds = FieldReaderFactory.readCountArrayField((String)"registeredNodeIds", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfRegisteredNodeIds, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("RegisterNodesResponse", new WithReaderArgs[0]);
        return new RegisterNodesResponseBuilderImpl(responseHeader, registeredNodeIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegisterNodesResponse)) {
            return false;
        }
        RegisterNodesResponse that = (RegisterNodesResponse)o;
        return this.getResponseHeader() == that.getResponseHeader() && this.getRegisteredNodeIds() == that.getRegisteredNodeIds() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseHeader(), this.getRegisteredNodeIds());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class RegisterNodesResponseBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ResponseHeader responseHeader;
        private final List<NodeId> registeredNodeIds;

        public RegisterNodesResponseBuilderImpl(ResponseHeader responseHeader, List<NodeId> registeredNodeIds) {
            this.responseHeader = responseHeader;
            this.registeredNodeIds = registeredNodeIds;
        }

        @Override
        public RegisterNodesResponse build() {
            RegisterNodesResponse registerNodesResponse = new RegisterNodesResponse(this.responseHeader, this.registeredNodeIds);
            return registerNodesResponse;
        }
    }
}

