/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ApplicationType;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class RegisteredServer
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString serverUri;
    protected final PascalString productUri;
    protected final List<LocalizedText> serverNames;
    protected final ApplicationType serverType;
    protected final PascalString gatewayServerUri;
    protected final List<PascalString> discoveryUrls;
    protected final PascalString semaphoreFilePath;
    protected final boolean isOnline;

    @Override
    public Integer getExtensionId() {
        return 434;
    }

    public RegisteredServer(PascalString serverUri, PascalString productUri, List<LocalizedText> serverNames, ApplicationType serverType, PascalString gatewayServerUri, List<PascalString> discoveryUrls, PascalString semaphoreFilePath, boolean isOnline) {
        this.serverUri = serverUri;
        this.productUri = productUri;
        this.serverNames = serverNames;
        this.serverType = serverType;
        this.gatewayServerUri = gatewayServerUri;
        this.discoveryUrls = discoveryUrls;
        this.semaphoreFilePath = semaphoreFilePath;
        this.isOnline = isOnline;
    }

    public PascalString getServerUri() {
        return this.serverUri;
    }

    public PascalString getProductUri() {
        return this.productUri;
    }

    public List<LocalizedText> getServerNames() {
        return this.serverNames;
    }

    public ApplicationType getServerType() {
        return this.serverType;
    }

    public PascalString getGatewayServerUri() {
        return this.gatewayServerUri;
    }

    public List<PascalString> getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    public PascalString getSemaphoreFilePath() {
        return this.semaphoreFilePath;
    }

    public boolean getIsOnline() {
        return this.isOnline;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("RegisteredServer", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serverUri", (Object)this.serverUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"productUri", (Object)this.productUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfServerNames = this.getServerNames() == null ? -1 : StaticHelper.COUNT(this.getServerNames());
        FieldWriterFactory.writeImplicitField((String)"noOfServerNames", (Object)noOfServerNames, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"serverNames", this.serverNames, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"serverType", (String)"ApplicationType", (Object)((Object)this.serverType), (DataWriter)DataWriterFactory.writeEnum(ApplicationType::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"gatewayServerUri", (Object)this.gatewayServerUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDiscoveryUrls = this.getDiscoveryUrls() == null ? -1 : StaticHelper.COUNT(this.getDiscoveryUrls());
        FieldWriterFactory.writeImplicitField((String)"noOfDiscoveryUrls", (Object)noOfDiscoveryUrls, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"discoveryUrls", this.discoveryUrls, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"semaphoreFilePath", (Object)this.semaphoreFilePath, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"isOnline", (Object)this.isOnline, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("RegisteredServer", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        RegisteredServer _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.serverUri.getLengthInBits();
        lengthInBits += this.productUri.getLengthInBits();
        lengthInBits += 32;
        if (this.serverNames != null) {
            i = 0;
            for (LocalizedText localizedText : this.serverNames) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.serverNames.size());
                lengthInBits += localizedText.getLengthInBits();
            }
        }
        lengthInBits += 32;
        lengthInBits += this.gatewayServerUri.getLengthInBits();
        lengthInBits += 32;
        if (this.discoveryUrls != null) {
            i = 0;
            for (PascalString pascalString : this.discoveryUrls) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.discoveryUrls.size());
                lengthInBits += pascalString.getLengthInBits();
            }
        }
        lengthInBits += this.semaphoreFilePath.getLengthInBits();
        lengthInBits += 7;
        return ++lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("RegisteredServer", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString serverUri = (PascalString)FieldReaderFactory.readSimpleField((String)"serverUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString productUri = (PascalString)FieldReaderFactory.readSimpleField((String)"productUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfServerNames = (Integer)FieldReaderFactory.readImplicitField((String)"noOfServerNames", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List serverNames = FieldReaderFactory.readCountArrayField((String)"serverNames", (DataReader)DataReaderFactory.readComplex(() -> LocalizedText.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfServerNames, (WithReaderArgs[])new WithReaderArgs[0]);
        ApplicationType serverType = (ApplicationType)((Object)FieldReaderFactory.readEnumField((String)"serverType", (String)"ApplicationType", (DataReader)DataReaderFactory.readEnum(ApplicationType::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        PascalString gatewayServerUri = (PascalString)FieldReaderFactory.readSimpleField((String)"gatewayServerUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDiscoveryUrls = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDiscoveryUrls", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List discoveryUrls = FieldReaderFactory.readCountArrayField((String)"discoveryUrls", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfDiscoveryUrls, (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString semaphoreFilePath = (PascalString)FieldReaderFactory.readSimpleField((String)"semaphoreFilePath", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isOnline = (Boolean)FieldReaderFactory.readSimpleField((String)"isOnline", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("RegisteredServer", new WithReaderArgs[0]);
        return new RegisteredServerBuilderImpl(serverUri, productUri, serverNames, serverType, gatewayServerUri, discoveryUrls, semaphoreFilePath, isOnline);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegisteredServer)) {
            return false;
        }
        RegisteredServer that = (RegisteredServer)o;
        return this.getServerUri() == that.getServerUri() && this.getProductUri() == that.getProductUri() && this.getServerNames() == that.getServerNames() && this.getServerType() == that.getServerType() && this.getGatewayServerUri() == that.getGatewayServerUri() && this.getDiscoveryUrls() == that.getDiscoveryUrls() && this.getSemaphoreFilePath() == that.getSemaphoreFilePath() && this.getIsOnline() == that.getIsOnline() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getServerUri(), this.getProductUri(), this.getServerNames(), this.getServerType(), this.getGatewayServerUri(), this.getDiscoveryUrls(), this.getSemaphoreFilePath(), this.getIsOnline()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class RegisteredServerBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString serverUri;
        private final PascalString productUri;
        private final List<LocalizedText> serverNames;
        private final ApplicationType serverType;
        private final PascalString gatewayServerUri;
        private final List<PascalString> discoveryUrls;
        private final PascalString semaphoreFilePath;
        private final boolean isOnline;

        public RegisteredServerBuilderImpl(PascalString serverUri, PascalString productUri, List<LocalizedText> serverNames, ApplicationType serverType, PascalString gatewayServerUri, List<PascalString> discoveryUrls, PascalString semaphoreFilePath, boolean isOnline) {
            this.serverUri = serverUri;
            this.productUri = productUri;
            this.serverNames = serverNames;
            this.serverType = serverType;
            this.gatewayServerUri = gatewayServerUri;
            this.discoveryUrls = discoveryUrls;
            this.semaphoreFilePath = semaphoreFilePath;
            this.isOnline = isOnline;
        }

        @Override
        public RegisteredServer build() {
            RegisteredServer registeredServer = new RegisteredServer(this.serverUri, this.productUri, this.serverNames, this.serverType, this.gatewayServerUri, this.discoveryUrls, this.semaphoreFilePath, this.isOnline);
            return registeredServer;
        }
    }
}

