/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ResponseHeader
extends ExtensionObjectDefinition
implements Message {
    protected final long timestamp;
    protected final long requestHandle;
    protected final StatusCode serviceResult;
    protected final DiagnosticInfo serviceDiagnostics;
    protected final List<PascalString> stringTable;
    protected final ExtensionObject additionalHeader;

    @Override
    public Integer getExtensionId() {
        return 394;
    }

    public ResponseHeader(long timestamp, long requestHandle, StatusCode serviceResult, DiagnosticInfo serviceDiagnostics, List<PascalString> stringTable, ExtensionObject additionalHeader) {
        this.timestamp = timestamp;
        this.requestHandle = requestHandle;
        this.serviceResult = serviceResult;
        this.serviceDiagnostics = serviceDiagnostics;
        this.stringTable = stringTable;
        this.additionalHeader = additionalHeader;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getRequestHandle() {
        return this.requestHandle;
    }

    public StatusCode getServiceResult() {
        return this.serviceResult;
    }

    public DiagnosticInfo getServiceDiagnostics() {
        return this.serviceDiagnostics;
    }

    public List<PascalString> getStringTable() {
        return this.stringTable;
    }

    public ExtensionObject getAdditionalHeader() {
        return this.additionalHeader;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ResponseHeader", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"timestamp", (Object)this.timestamp, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHandle", (Object)this.requestHandle, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serviceResult", (Object)this.serviceResult, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serviceDiagnostics", (Object)this.serviceDiagnostics, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfStringTable = this.getStringTable() == null ? -1 : StaticHelper.COUNT(this.getStringTable());
        FieldWriterFactory.writeImplicitField((String)"noOfStringTable", (Object)noOfStringTable, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"stringTable", this.stringTable, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"additionalHeader", (Object)this.additionalHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ResponseHeader", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ResponseHeader _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 64;
        lengthInBits += 32;
        lengthInBits += this.serviceResult.getLengthInBits();
        lengthInBits += this.serviceDiagnostics.getLengthInBits();
        lengthInBits += 32;
        if (this.stringTable != null) {
            int i = 0;
            for (PascalString element : this.stringTable) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.stringTable.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits += this.additionalHeader.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ResponseHeader", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long timestamp = (Long)FieldReaderFactory.readSimpleField((String)"timestamp", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        long requestHandle = (Long)FieldReaderFactory.readSimpleField((String)"requestHandle", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        StatusCode serviceResult = (StatusCode)FieldReaderFactory.readSimpleField((String)"serviceResult", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        DiagnosticInfo serviceDiagnostics = (DiagnosticInfo)FieldReaderFactory.readSimpleField((String)"serviceDiagnostics", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfStringTable = (Integer)FieldReaderFactory.readImplicitField((String)"noOfStringTable", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List stringTable = FieldReaderFactory.readCountArrayField((String)"stringTable", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfStringTable, (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject additionalHeader = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"additionalHeader", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ResponseHeader", new WithReaderArgs[0]);
        return new ResponseHeaderBuilderImpl(timestamp, requestHandle, serviceResult, serviceDiagnostics, stringTable, additionalHeader);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponseHeader)) {
            return false;
        }
        ResponseHeader that = (ResponseHeader)o;
        return this.getTimestamp() == that.getTimestamp() && this.getRequestHandle() == that.getRequestHandle() && this.getServiceResult() == that.getServiceResult() && this.getServiceDiagnostics() == that.getServiceDiagnostics() && this.getStringTable() == that.getStringTable() && this.getAdditionalHeader() == that.getAdditionalHeader() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTimestamp(), this.getRequestHandle(), this.getServiceResult(), this.getServiceDiagnostics(), this.getStringTable(), this.getAdditionalHeader());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ResponseHeaderBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long timestamp;
        private final long requestHandle;
        private final StatusCode serviceResult;
        private final DiagnosticInfo serviceDiagnostics;
        private final List<PascalString> stringTable;
        private final ExtensionObject additionalHeader;

        public ResponseHeaderBuilderImpl(long timestamp, long requestHandle, StatusCode serviceResult, DiagnosticInfo serviceDiagnostics, List<PascalString> stringTable, ExtensionObject additionalHeader) {
            this.timestamp = timestamp;
            this.requestHandle = requestHandle;
            this.serviceResult = serviceResult;
            this.serviceDiagnostics = serviceDiagnostics;
            this.stringTable = stringTable;
            this.additionalHeader = additionalHeader;
        }

        @Override
        public ResponseHeader build() {
            ResponseHeader responseHeader = new ResponseHeader(this.timestamp, this.requestHandle, this.serviceResult, this.serviceDiagnostics, this.stringTable, this.additionalHeader);
            return responseHeader;
        }
    }
}

