/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.BuildInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.ServerState;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ServerStatusDataType
extends ExtensionObjectDefinition
implements Message {
    protected final long startTime;
    protected final long currentTime;
    protected final ServerState state;
    protected final BuildInfo buildInfo;
    protected final long secondsTillShutdown;
    protected final LocalizedText shutdownReason;

    @Override
    public Integer getExtensionId() {
        return 864;
    }

    public ServerStatusDataType(long startTime, long currentTime, ServerState state, BuildInfo buildInfo, long secondsTillShutdown, LocalizedText shutdownReason) {
        this.startTime = startTime;
        this.currentTime = currentTime;
        this.state = state;
        this.buildInfo = buildInfo;
        this.secondsTillShutdown = secondsTillShutdown;
        this.shutdownReason = shutdownReason;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public ServerState getState() {
        return this.state;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public long getSecondsTillShutdown() {
        return this.secondsTillShutdown;
    }

    public LocalizedText getShutdownReason() {
        return this.shutdownReason;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ServerStatusDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"startTime", (Object)this.startTime, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"currentTime", (Object)this.currentTime, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"state", (String)"ServerState", (Object)((Object)this.state), (DataWriter)DataWriterFactory.writeEnum(ServerState::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"buildInfo", (Object)this.buildInfo, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"secondsTillShutdown", (Object)this.secondsTillShutdown, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"shutdownReason", (Object)this.shutdownReason, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ServerStatusDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ServerStatusDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 64;
        lengthInBits += 64;
        lengthInBits += 32;
        lengthInBits += this.buildInfo.getLengthInBits();
        lengthInBits += 32;
        return lengthInBits += this.shutdownReason.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ServerStatusDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long startTime = (Long)FieldReaderFactory.readSimpleField((String)"startTime", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        long currentTime = (Long)FieldReaderFactory.readSimpleField((String)"currentTime", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        ServerState state = (ServerState)((Object)FieldReaderFactory.readEnumField((String)"state", (String)"ServerState", (DataReader)DataReaderFactory.readEnum(ServerState::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        BuildInfo buildInfo = (BuildInfo)FieldReaderFactory.readSimpleField((String)"buildInfo", (DataReader)DataReaderFactory.readComplex(() -> (BuildInfo)ExtensionObjectDefinition.staticParse(readBuffer, 340), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long secondsTillShutdown = (Long)FieldReaderFactory.readSimpleField((String)"secondsTillShutdown", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        LocalizedText shutdownReason = (LocalizedText)FieldReaderFactory.readSimpleField((String)"shutdownReason", (DataReader)DataReaderFactory.readComplex(() -> LocalizedText.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ServerStatusDataType", new WithReaderArgs[0]);
        return new ServerStatusDataTypeBuilderImpl(startTime, currentTime, state, buildInfo, secondsTillShutdown, shutdownReason);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerStatusDataType)) {
            return false;
        }
        ServerStatusDataType that = (ServerStatusDataType)o;
        return this.getStartTime() == that.getStartTime() && this.getCurrentTime() == that.getCurrentTime() && this.getState() == that.getState() && this.getBuildInfo() == that.getBuildInfo() && this.getSecondsTillShutdown() == that.getSecondsTillShutdown() && this.getShutdownReason() == that.getShutdownReason() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getStartTime(), this.getCurrentTime(), this.getState(), this.getBuildInfo(), this.getSecondsTillShutdown(), this.getShutdownReason()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ServerStatusDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long startTime;
        private final long currentTime;
        private final ServerState state;
        private final BuildInfo buildInfo;
        private final long secondsTillShutdown;
        private final LocalizedText shutdownReason;

        public ServerStatusDataTypeBuilderImpl(long startTime, long currentTime, ServerState state, BuildInfo buildInfo, long secondsTillShutdown, LocalizedText shutdownReason) {
            this.startTime = startTime;
            this.currentTime = currentTime;
            this.state = state;
            this.buildInfo = buildInfo;
            this.secondsTillShutdown = secondsTillShutdown;
            this.shutdownReason = shutdownReason;
        }

        @Override
        public ServerStatusDataType build() {
            ServerStatusDataType serverStatusDataType = new ServerStatusDataType(this.startTime, this.currentTime, this.state, this.buildInfo, this.secondsTillShutdown, this.shutdownReason);
            return serverStatusDataType;
        }
    }
}

