/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ResponseHeader;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class SetTriggeringResponse
extends ExtensionObjectDefinition
implements Message {
    protected final ResponseHeader responseHeader;
    protected final List<StatusCode> addResults;
    protected final List<DiagnosticInfo> addDiagnosticInfos;
    protected final List<StatusCode> removeResults;
    protected final List<DiagnosticInfo> removeDiagnosticInfos;

    @Override
    public Integer getExtensionId() {
        return 778;
    }

    public SetTriggeringResponse(ResponseHeader responseHeader, List<StatusCode> addResults, List<DiagnosticInfo> addDiagnosticInfos, List<StatusCode> removeResults, List<DiagnosticInfo> removeDiagnosticInfos) {
        this.responseHeader = responseHeader;
        this.addResults = addResults;
        this.addDiagnosticInfos = addDiagnosticInfos;
        this.removeResults = removeResults;
        this.removeDiagnosticInfos = removeDiagnosticInfos;
    }

    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public List<StatusCode> getAddResults() {
        return this.addResults;
    }

    public List<DiagnosticInfo> getAddDiagnosticInfos() {
        return this.addDiagnosticInfos;
    }

    public List<StatusCode> getRemoveResults() {
        return this.removeResults;
    }

    public List<DiagnosticInfo> getRemoveDiagnosticInfos() {
        return this.removeDiagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SetTriggeringResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"responseHeader", (Object)this.responseHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfAddResults = this.getAddResults() == null ? -1 : StaticHelper.COUNT(this.getAddResults());
        FieldWriterFactory.writeImplicitField((String)"noOfAddResults", (Object)noOfAddResults, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"addResults", this.addResults, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfAddDiagnosticInfos = this.getAddDiagnosticInfos() == null ? -1 : StaticHelper.COUNT(this.getAddDiagnosticInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfAddDiagnosticInfos", (Object)noOfAddDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"addDiagnosticInfos", this.addDiagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfRemoveResults = this.getRemoveResults() == null ? -1 : StaticHelper.COUNT(this.getRemoveResults());
        FieldWriterFactory.writeImplicitField((String)"noOfRemoveResults", (Object)noOfRemoveResults, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"removeResults", this.removeResults, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfRemoveDiagnosticInfos = this.getRemoveDiagnosticInfos() == null ? -1 : StaticHelper.COUNT(this.getRemoveDiagnosticInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfRemoveDiagnosticInfos", (Object)noOfRemoveDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"removeDiagnosticInfos", this.removeDiagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("SetTriggeringResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        SetTriggeringResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.responseHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.addResults != null) {
            i = 0;
            for (StatusCode statusCode : this.addResults) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.addResults.size());
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.addDiagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.addDiagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.addDiagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.removeResults != null) {
            i = 0;
            for (StatusCode statusCode : this.removeResults) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.removeResults.size());
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.removeDiagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.removeDiagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.removeDiagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("SetTriggeringResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ResponseHeader responseHeader = (ResponseHeader)FieldReaderFactory.readSimpleField((String)"responseHeader", (DataReader)DataReaderFactory.readComplex(() -> (ResponseHeader)ExtensionObjectDefinition.staticParse(readBuffer, 394), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfAddResults = (Integer)FieldReaderFactory.readImplicitField((String)"noOfAddResults", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List addResults = FieldReaderFactory.readCountArrayField((String)"addResults", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfAddResults, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfAddDiagnosticInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfAddDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List addDiagnosticInfos = FieldReaderFactory.readCountArrayField((String)"addDiagnosticInfos", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfAddDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfRemoveResults = (Integer)FieldReaderFactory.readImplicitField((String)"noOfRemoveResults", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List removeResults = FieldReaderFactory.readCountArrayField((String)"removeResults", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfRemoveResults, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfRemoveDiagnosticInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfRemoveDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List removeDiagnosticInfos = FieldReaderFactory.readCountArrayField((String)"removeDiagnosticInfos", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfRemoveDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("SetTriggeringResponse", new WithReaderArgs[0]);
        return new SetTriggeringResponseBuilderImpl(responseHeader, addResults, addDiagnosticInfos, removeResults, removeDiagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SetTriggeringResponse)) {
            return false;
        }
        SetTriggeringResponse that = (SetTriggeringResponse)o;
        return this.getResponseHeader() == that.getResponseHeader() && this.getAddResults() == that.getAddResults() && this.getAddDiagnosticInfos() == that.getAddDiagnosticInfos() && this.getRemoveResults() == that.getRemoveResults() && this.getRemoveDiagnosticInfos() == that.getRemoveDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseHeader(), this.getAddResults(), this.getAddDiagnosticInfos(), this.getRemoveResults(), this.getRemoveDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class SetTriggeringResponseBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ResponseHeader responseHeader;
        private final List<StatusCode> addResults;
        private final List<DiagnosticInfo> addDiagnosticInfos;
        private final List<StatusCode> removeResults;
        private final List<DiagnosticInfo> removeDiagnosticInfos;

        public SetTriggeringResponseBuilderImpl(ResponseHeader responseHeader, List<StatusCode> addResults, List<DiagnosticInfo> addDiagnosticInfos, List<StatusCode> removeResults, List<DiagnosticInfo> removeDiagnosticInfos) {
            this.responseHeader = responseHeader;
            this.addResults = addResults;
            this.addDiagnosticInfos = addDiagnosticInfos;
            this.removeResults = removeResults;
            this.removeDiagnosticInfos = removeDiagnosticInfos;
        }

        @Override
        public SetTriggeringResponse build() {
            SetTriggeringResponse setTriggeringResponse = new SetTriggeringResponse(this.responseHeader, this.addResults, this.addDiagnosticInfos, this.removeResults, this.removeDiagnosticInfos);
            return setTriggeringResponse;
        }
    }
}

