/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class TransferSubscriptionsRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final List<Long> subscriptionIds;
    protected final boolean sendInitialValues;

    @Override
    public Integer getExtensionId() {
        return 841;
    }

    public TransferSubscriptionsRequest(RequestHeader requestHeader, List<Long> subscriptionIds, boolean sendInitialValues) {
        this.requestHeader = requestHeader;
        this.subscriptionIds = subscriptionIds;
        this.sendInitialValues = sendInitialValues;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public List<Long> getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public boolean getSendInitialValues() {
        return this.sendInitialValues;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("TransferSubscriptionsRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSubscriptionIds = this.getSubscriptionIds() == null ? -1 : StaticHelper.COUNT(this.getSubscriptionIds());
        FieldWriterFactory.writeImplicitField((String)"noOfSubscriptionIds", (Object)noOfSubscriptionIds, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"subscriptionIds", this.subscriptionIds, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sendInitialValues", (Object)this.sendInitialValues, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("TransferSubscriptionsRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        TransferSubscriptionsRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.subscriptionIds != null) {
            lengthInBits += 32 * this.subscriptionIds.size();
        }
        lengthInBits += 7;
        return ++lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("TransferSubscriptionsRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSubscriptionIds = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSubscriptionIds", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List subscriptionIds = FieldReaderFactory.readCountArrayField((String)"subscriptionIds", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (long)noOfSubscriptionIds, (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean sendInitialValues = (Boolean)FieldReaderFactory.readSimpleField((String)"sendInitialValues", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("TransferSubscriptionsRequest", new WithReaderArgs[0]);
        return new TransferSubscriptionsRequestBuilderImpl(requestHeader, subscriptionIds, sendInitialValues);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransferSubscriptionsRequest)) {
            return false;
        }
        TransferSubscriptionsRequest that = (TransferSubscriptionsRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getSubscriptionIds() == that.getSubscriptionIds() && this.getSendInitialValues() == that.getSendInitialValues() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getSubscriptionIds(), this.getSendInitialValues());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class TransferSubscriptionsRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final List<Long> subscriptionIds;
        private final boolean sendInitialValues;

        public TransferSubscriptionsRequestBuilderImpl(RequestHeader requestHeader, List<Long> subscriptionIds, boolean sendInitialValues) {
            this.requestHeader = requestHeader;
            this.subscriptionIds = subscriptionIds;
            this.sendInitialValues = sendInitialValues;
        }

        @Override
        public TransferSubscriptionsRequest build() {
            TransferSubscriptionsRequest transferSubscriptionsRequest = new TransferSubscriptionsRequest(this.requestHeader, this.subscriptionIds, this.sendInitialValues);
            return transferSubscriptionsRequest;
        }
    }
}

