/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataValue;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PerformUpdateType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class UpdateStructureDataDetails
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId nodeId;
    protected final PerformUpdateType performInsertReplace;
    protected final List<DataValue> updateValues;

    @Override
    public Integer getExtensionId() {
        return 11297;
    }

    public UpdateStructureDataDetails(NodeId nodeId, PerformUpdateType performInsertReplace, List<DataValue> updateValues) {
        this.nodeId = nodeId;
        this.performInsertReplace = performInsertReplace;
        this.updateValues = updateValues;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public PerformUpdateType getPerformInsertReplace() {
        return this.performInsertReplace;
    }

    public List<DataValue> getUpdateValues() {
        return this.updateValues;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("UpdateStructureDataDetails", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"nodeId", (Object)this.nodeId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"performInsertReplace", (String)"PerformUpdateType", (Object)((Object)this.performInsertReplace), (DataWriter)DataWriterFactory.writeEnum(PerformUpdateType::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfUpdateValues = this.getUpdateValues() == null ? -1 : StaticHelper.COUNT(this.getUpdateValues());
        FieldWriterFactory.writeImplicitField((String)"noOfUpdateValues", (Object)noOfUpdateValues, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"updateValues", this.updateValues, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("UpdateStructureDataDetails", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        UpdateStructureDataDetails _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.nodeId.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.updateValues != null) {
            int i = 0;
            for (DataValue element : this.updateValues) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.updateValues.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("UpdateStructureDataDetails", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId nodeId = (NodeId)FieldReaderFactory.readSimpleField((String)"nodeId", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PerformUpdateType performInsertReplace = (PerformUpdateType)((Object)FieldReaderFactory.readEnumField((String)"performInsertReplace", (String)"PerformUpdateType", (DataReader)DataReaderFactory.readEnum(PerformUpdateType::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        int noOfUpdateValues = (Integer)FieldReaderFactory.readImplicitField((String)"noOfUpdateValues", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List updateValues = FieldReaderFactory.readCountArrayField((String)"updateValues", (DataReader)DataReaderFactory.readComplex(() -> DataValue.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfUpdateValues, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("UpdateStructureDataDetails", new WithReaderArgs[0]);
        return new UpdateStructureDataDetailsBuilderImpl(nodeId, performInsertReplace, updateValues);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateStructureDataDetails)) {
            return false;
        }
        UpdateStructureDataDetails that = (UpdateStructureDataDetails)o;
        return this.getNodeId() == that.getNodeId() && this.getPerformInsertReplace() == that.getPerformInsertReplace() && this.getUpdateValues() == that.getUpdateValues() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getNodeId(), this.getPerformInsertReplace(), this.getUpdateValues()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class UpdateStructureDataDetailsBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId nodeId;
        private final PerformUpdateType performInsertReplace;
        private final List<DataValue> updateValues;

        public UpdateStructureDataDetailsBuilderImpl(NodeId nodeId, PerformUpdateType performInsertReplace, List<DataValue> updateValues) {
            this.nodeId = nodeId;
            this.performInsertReplace = performInsertReplace;
            this.updateValues = updateValues;
        }

        @Override
        public UpdateStructureDataDetails build() {
            UpdateStructureDataDetails updateStructureDataDetails = new UpdateStructureDataDetails(this.nodeId, this.performInsertReplace, this.updateValues);
            return updateStructureDataDetails;
        }
    }
}

