/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.security;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.plc4x.java.opcua.security.CertificateVerifier;

public class TrustStoreCertificateVerifier
implements CertificateVerifier {
    private X509TrustManager trustManager;

    public TrustStoreCertificateVerifier(KeyStore trustStore) throws GeneralSecurityException {
        TrustManager[] managers;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagerArray = managers = trustManagerFactory.getTrustManagers();
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager manager = trustManagerArray[n2];
            if (manager instanceof X509TrustManager) {
                this.trustManager = (X509TrustManager)manager;
                break;
            }
            ++n2;
        }
        if (this.trustManager == null) {
            throw new IllegalStateException("Could not initialize trust manager, underlying trust provider not found");
        }
    }

    @Override
    public void checkCertificateTrusted(X509Certificate certificate) throws CertificateException {
        this.trustManager.checkClientTrusted(new X509Certificate[]{certificate}, "UNKNOWN");
    }
}

