/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.openprotocol.readwrite.Mid;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageAlarm;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageAlarmAcknowledge;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageAlarmStatus;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageAlarmStatusAcknowledge;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageAlarmSubscribe;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageAlarmUnsubscribe;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageApplicationCommandAccepted;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageApplicationCommandError;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageApplicationCommunicationStart;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageApplicationCommunicationStartAcknowledge;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageApplicationCommunicationStop;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageApplicationGenericDataRequest;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageApplicationGenericSubscription;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageApplicationGenericUnsubscribe;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageDisableTool;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageDynamicPsetSelection;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageEnableTool;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageExecuteDynamicJobRequest;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageIdentifierDownloadRequest;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageKeepAliveOpenProtocolCommunication;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageLastTighteningResultData;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageLastTighteningResultDataSubscribe;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageLinkLevelNegativeAcknowledge;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageLinkLevelPositiveAcknowledge;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageLockAtBatchDoneSubscribe;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageLockAtBatchDoneUnsubscribe;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageLockAtBatchDoneUpload;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageLockAtBatchDoneUploadAcknowledge;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageParameterSetDataUploadReply;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageParameterSetDataUploadRequest;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageParameterSetIdUploadReply;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageParameterSetIdUploadRequest;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageParameterSetSelected;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageParameterSetSelectedAcknowledge;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageParameterSetSelectedSubscribe;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageParameterSetSelectedUnsubscribe;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageProgramPsetSelectionInDynamicJob;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageResetParameterSetBatchCounter;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageResultTracesCurve;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageResultTracesCurvePlotData;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageSelectParameterSet;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageSetParameterSetBatchSize;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessageSetTime;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class OpenProtocolMessage
implements Message {
    public static final Short END = 0;
    protected final Integer midRevision;
    protected final Short noAckFlag;
    protected final Integer targetStationId;
    protected final Integer targetSpindleId;
    protected final Integer sequenceNumber;
    protected final Short numberOfMessageParts;
    protected final Short messagePartNumber;

    public abstract Mid getMid();

    public OpenProtocolMessage(Integer midRevision, Short noAckFlag, Integer targetStationId, Integer targetSpindleId, Integer sequenceNumber, Short numberOfMessageParts, Short messagePartNumber) {
        this.midRevision = midRevision;
        this.noAckFlag = noAckFlag;
        this.targetStationId = targetStationId;
        this.targetSpindleId = targetSpindleId;
        this.sequenceNumber = sequenceNumber;
        this.numberOfMessageParts = numberOfMessageParts;
        this.messagePartNumber = messagePartNumber;
    }

    public Integer getMidRevision() {
        return this.midRevision;
    }

    public Short getNoAckFlag() {
        return this.noAckFlag;
    }

    public Integer getTargetStationId() {
        return this.targetStationId;
    }

    public Integer getTargetSpindleId() {
        return this.targetSpindleId;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Short getNumberOfMessageParts() {
        return this.numberOfMessageParts;
    }

    public Short getMessagePartNumber() {
        return this.messagePartNumber;
    }

    public short getEnd() {
        return END;
    }

    protected abstract void serializeOpenProtocolMessageChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpenProtocolMessage", new WithWriterArgs[0]);
        long length = (long)this.getLengthInBytes() - 1L;
        FieldWriterFactory.writeImplicitField((String)"length", (Object)length, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII")});
        FieldWriterFactory.writeDiscriminatorEnumField((String)"mid", (String)"Mid", (Object)((Object)this.getMid()), (DataWriter)new DataWriterEnumDefault(Mid::getValue, Enum::name, DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII")});
        FieldWriterFactory.writeOptionalField((String)"midRevision", (Object)this.midRevision, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)24), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"202020")});
        FieldWriterFactory.writeOptionalField((String)"noAckFlag", (Object)this.noAckFlag, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"20")});
        FieldWriterFactory.writeOptionalField((String)"targetStationId", (Object)this.targetStationId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"2020")});
        FieldWriterFactory.writeOptionalField((String)"targetSpindleId", (Object)this.targetSpindleId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"2020")});
        FieldWriterFactory.writeOptionalField((String)"sequenceNumber", (Object)this.sequenceNumber, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"2020")});
        FieldWriterFactory.writeOptionalField((String)"numberOfMessageParts", (Object)this.numberOfMessageParts, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"20")});
        FieldWriterFactory.writeOptionalField((String)"messagePartNumber", (Object)this.messagePartNumber, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"20")});
        this.serializeOpenProtocolMessageChild(writeBuffer);
        FieldWriterFactory.writeConstField((String)"end", (Object)END, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpenProtocolMessage", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        OpenProtocolMessage _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 24;
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 8;
        lengthInBits += 8;
        return lengthInBits += 8;
    }

    public static OpenProtocolMessage staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer revision;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            revision = (Integer)args[0];
        } else if (args[0] instanceof String) {
            revision = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return OpenProtocolMessage.staticParse(readBuffer, revision);
    }

    public static OpenProtocolMessage staticParse(ReadBuffer readBuffer, Integer revision) throws ParseException {
        readBuffer.pullContext("OpenProtocolMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long length = (Long)FieldReaderFactory.readImplicitField((String)"length", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII")});
        Mid mid = (Mid)((Object)FieldReaderFactory.readDiscriminatorEnumField((String)"mid", (String)"Mid", (DataReader)new DataReaderEnumDefault(Mid::enumForValue, DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII")}));
        Integer midRevision = (Integer)FieldReaderFactory.readOptionalField((String)"midRevision", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)24), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"202020")});
        Short noAckFlag = (Short)FieldReaderFactory.readOptionalField((String)"noAckFlag", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"20")});
        Integer targetStationId = (Integer)FieldReaderFactory.readOptionalField((String)"targetStationId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"2020")});
        Integer targetSpindleId = (Integer)FieldReaderFactory.readOptionalField((String)"targetSpindleId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"2020")});
        Integer sequenceNumber = (Integer)FieldReaderFactory.readOptionalField((String)"sequenceNumber", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"2020")});
        Short numberOfMessageParts = (Short)FieldReaderFactory.readOptionalField((String)"numberOfMessageParts", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"20")});
        Short messagePartNumber = (Short)FieldReaderFactory.readOptionalField((String)"messagePartNumber", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII"), WithOption.WithNullBytesHex((String)"20")});
        OpenProtocolMessageBuilder builder = null;
        if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ApplicationCommunicationStart))) {
            builder = OpenProtocolMessageApplicationCommunicationStart.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ApplicationCommunicationStartAcknowledge))) {
            builder = OpenProtocolMessageApplicationCommunicationStartAcknowledge.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ApplicationCommunicationStop))) {
            builder = OpenProtocolMessageApplicationCommunicationStop.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ApplicationCommandError))) {
            builder = OpenProtocolMessageApplicationCommandError.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ApplicationCommandAccepted))) {
            builder = OpenProtocolMessageApplicationCommandAccepted.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ApplicationGenericDataRequest))) {
            builder = OpenProtocolMessageApplicationGenericDataRequest.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ApplicationGenericSubscription))) {
            builder = OpenProtocolMessageApplicationGenericSubscription.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ApplicationGenericUnsubscribe))) {
            builder = OpenProtocolMessageApplicationGenericUnsubscribe.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ParameterSetIdUploadRequest))) {
            builder = OpenProtocolMessageParameterSetIdUploadRequest.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ParameterSetIdUploadReply))) {
            builder = OpenProtocolMessageParameterSetIdUploadReply.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ParameterSetDataUploadRequest))) {
            builder = OpenProtocolMessageParameterSetDataUploadRequest.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ParameterSetDataUploadReply))) {
            builder = OpenProtocolMessageParameterSetDataUploadReply.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ParameterSetSelectedSubscribe))) {
            builder = OpenProtocolMessageParameterSetSelectedSubscribe.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ParameterSetSelected))) {
            builder = OpenProtocolMessageParameterSetSelected.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ParameterSetSelectedAcknowledge))) {
            builder = OpenProtocolMessageParameterSetSelectedAcknowledge.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ParameterSetSelectedUnsubscribe))) {
            builder = OpenProtocolMessageParameterSetSelectedUnsubscribe.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.SelectParameterSet))) {
            builder = OpenProtocolMessageSelectParameterSet.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.SetParameterSetBatchSize))) {
            builder = OpenProtocolMessageSetParameterSetBatchSize.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ResetParameterSetBatchCounter))) {
            builder = OpenProtocolMessageResetParameterSetBatchCounter.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.LockAtBatchDoneSubscribe))) {
            builder = OpenProtocolMessageLockAtBatchDoneSubscribe.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.LockAtBatchDoneUpload))) {
            builder = OpenProtocolMessageLockAtBatchDoneUpload.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.LockAtBatchDoneUploadAcknowledge))) {
            builder = OpenProtocolMessageLockAtBatchDoneUploadAcknowledge.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.LockAtBatchDoneUnsubscribe))) {
            builder = OpenProtocolMessageLockAtBatchDoneUnsubscribe.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.DisableTool))) {
            builder = OpenProtocolMessageDisableTool.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.EnableTool))) {
            builder = OpenProtocolMessageEnableTool.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.LastTighteningResultDataSubscribe))) {
            builder = OpenProtocolMessageLastTighteningResultDataSubscribe.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.LastTighteningResultData))) {
            builder = OpenProtocolMessageLastTighteningResultData.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.AlarmSubscribe))) {
            builder = OpenProtocolMessageAlarmSubscribe.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.Alarm))) {
            builder = OpenProtocolMessageAlarm.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.AlarmAcknowledge))) {
            builder = OpenProtocolMessageAlarmAcknowledge.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.AlarmUnsubscribe))) {
            builder = OpenProtocolMessageAlarmUnsubscribe.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.AlarmStatus))) {
            builder = OpenProtocolMessageAlarmStatus.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.AlarmStatusAcknowledge))) {
            builder = OpenProtocolMessageAlarmStatusAcknowledge.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.SetTime))) {
            builder = OpenProtocolMessageSetTime.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ExecuteDynamicJobRequest))) {
            builder = OpenProtocolMessageExecuteDynamicJobRequest.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.IdentifierDownloadRequest))) {
            builder = OpenProtocolMessageIdentifierDownloadRequest.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ResultTracesCurve))) {
            builder = OpenProtocolMessageResultTracesCurve.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ResultTracesCurvePlotData))) {
            builder = OpenProtocolMessageResultTracesCurvePlotData.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.ProgramPsetSelectionInDynamicJob))) {
            builder = OpenProtocolMessageProgramPsetSelectionInDynamicJob.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.DynamicPsetSelection))) {
            builder = OpenProtocolMessageDynamicPsetSelection.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.LinkLevelPositiveAcknowledge))) {
            builder = OpenProtocolMessageLinkLevelPositiveAcknowledge.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.LinkLevelNegativeAcknowledge))) {
            builder = OpenProtocolMessageLinkLevelNegativeAcknowledge.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        } else if (EvaluationHelper.equals((Object)((Object)mid), (Object)((Object)Mid.KeepAliveOpenProtocolCommunication))) {
            builder = OpenProtocolMessageKeepAliveOpenProtocolCommunication.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [mid=" + (Object)((Object)mid) + "]");
        }
        short end = (Short)FieldReaderFactory.readConstField((String)"end", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (Object)END, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpenProtocolMessage", new WithReaderArgs[0]);
        OpenProtocolMessage _openProtocolMessage = builder.build(midRevision, noAckFlag, targetStationId, targetSpindleId, sequenceNumber, numberOfMessageParts, messagePartNumber);
        return _openProtocolMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenProtocolMessage)) {
            return false;
        }
        OpenProtocolMessage that = (OpenProtocolMessage)o;
        return this.getMidRevision() == that.getMidRevision() && this.getNoAckFlag() == that.getNoAckFlag() && this.getTargetStationId() == that.getTargetStationId() && this.getTargetSpindleId() == that.getTargetSpindleId() && this.getSequenceNumber() == that.getSequenceNumber() && this.getNumberOfMessageParts() == that.getNumberOfMessageParts() && this.getMessagePartNumber() == that.getMessagePartNumber();
    }

    public int hashCode() {
        return Objects.hash(this.getMidRevision(), this.getNoAckFlag(), this.getTargetStationId(), this.getTargetSpindleId(), this.getSequenceNumber(), this.getNumberOfMessageParts(), this.getMessagePartNumber());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface OpenProtocolMessageBuilder {
        public OpenProtocolMessage build(Integer var1, Short var2, Integer var3, Integer var4, Integer var5, Short var6, Short var7);
    }
}

