/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum Strategy {
    TorqueControl(1),
    TorqueControlAngleMonitoring(2),
    TorqueControlAngleControlAnd(3),
    AngleControlTorqueMonitoring(4),
    DsControl(5),
    DsControlTorqueMonitoring(6),
    ReverseAngle(7),
    ReverseTorque(8),
    ClickWrench(9),
    RotateSpindleForward(10),
    TorqueControlAngleControlOr(11),
    RotateSpindleReverse(12),
    HomePositionForward(13),
    EpMonitoring(14),
    Yield(15),
    EpFixed(16),
    EpControl(17),
    EpAngleShutoff(18),
    YieldTorqueControlOr(19),
    SnugGradient(20),
    ResidualTorqueTime(21),
    ResidualTorqueAngle(22),
    BreakawayPeak(23),
    LooseAndTightening(24),
    HomePositionReverse(25),
    PvtCompWithSnug(26),
    NoStrategy(99);

    private static final Map<Integer, Strategy> map;
    private final int value;

    static {
        map = new HashMap<Integer, Strategy>();
        Strategy[] strategyArray = Strategy.values();
        int n = strategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Strategy value = strategyArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private Strategy(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static Strategy enumForValue(int value) {
        return map.get(value);
    }

    public static Boolean isDefined(int value) {
        return map.containsKey(value);
    }
}

