/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.plc4x;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.plc4x.config.Plc4xConfiguration;
import org.apache.plc4x.java.plc4x.config.Plc4xTcpTransportConfiguration;
import org.apache.plc4x.java.plc4x.protocol.Plc4xProtocolLogic;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xMessage;
import org.apache.plc4x.java.plc4x.tag.Plc4XTagHandler;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;

public class Plc4xDriver
extends GeneratedDriverBase<Plc4xMessage> {
    public String getProtocolCode() {
        return "plc4x";
    }

    public String getProtocolName() {
        return "PLC4X (Proxy-Protocol)";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return Plc4xConfiguration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(Plc4xTcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("tcp");
    }

    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("tcp");
    }

    protected PlcTagHandler getTagHandler() {
        return new Plc4XTagHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new org.apache.plc4x.java.spi.values.PlcValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected ProtocolStackConfigurer<Plc4xMessage> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(Plc4xMessage.class, (readBuffer, objectArray) -> Plc4xMessage.staticParse(readBuffer, objectArray)).withProtocol(Plc4xProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).build();
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 3) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 1);
            }
            return -1;
        }
    }
}

