/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.plc4x.protocol;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.plc4x.config.Plc4xConfiguration;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xConnectRequest;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xConnectResponse;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xMessage;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xReadRequest;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xReadResponse;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xResponseCode;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xTagRequest;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xTagResponse;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xTagValueRequest;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xTagValueResponse;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xValueType;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xWriteRequest;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xWriteResponse;
import org.apache.plc4x.java.plc4x.tag.Plc4xTag;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4xProtocolLogic
extends Plc4xProtocolBase<Plc4xMessage>
implements HasConfiguration<Plc4xConfiguration> {
    private final Logger logger = LoggerFactory.getLogger(Plc4xProtocolLogic.class);
    private final AtomicInteger txIdGenerator = new AtomicInteger(1);
    private String remoteConnectionString;
    private Duration requestTimeout;
    private RequestTransactionManager tm;
    private int connectionId;

    public void setConfiguration(Plc4xConfiguration configuration) {
        this.tm = new RequestTransactionManager(1);
        this.remoteConnectionString = configuration.getRemoteConnectionString();
        this.requestTimeout = Duration.ofMillis(configuration.getRequestTimeout());
        this.connectionId = 0;
    }

    public void close(ConversationContext<Plc4xMessage> context) {
        this.tm.shutdown();
    }

    public void onConnect(ConversationContext<Plc4xMessage> context) {
        int requestId = this.txIdGenerator.getAndIncrement();
        Plc4xConnectRequest connectRequest = new Plc4xConnectRequest(requestId, this.remoteConnectionString);
        context.sendRequest((Object)connectRequest).onTimeout(e -> {
            this.logger.warn("Timeout during Connection establishing, closing channel...");
            context.getChannel().close();
        }).expectResponse(Plc4xMessage.class, this.requestTimeout).check(p -> p.getRequestId() == requestId).only(Plc4xConnectResponse.class).handle(connectResponse -> {
            this.connectionId = connectResponse.getConnectionId();
            this.logger.debug("Got Plc4x Connection Response");
            context.fireConnected();
        });
    }

    public void onDisconnect(ConversationContext<Plc4xMessage> context) {
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest apiReadRequest) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        ArrayList<Plc4xTagRequest> plc4xTags = new ArrayList<Plc4xTagRequest>(apiReadRequest.getNumberOfTags());
        for (String tagName : apiReadRequest.getTagNames()) {
            Plc4xTag plc4xTag = (Plc4xTag)apiReadRequest.getTag(tagName);
            Plc4xTagRequest plc4XTagRequest = new Plc4xTagRequest(new org.apache.plc4x.java.plc4x.readwrite.Plc4xTag(tagName, String.valueOf(plc4xTag.getAddressString()) + ":" + plc4xTag.getPlcValueType().name()));
            plc4xTags.add(plc4XTagRequest);
        }
        int requestId = this.txIdGenerator.getAndIncrement();
        Plc4xReadRequest plc4xReadRequest = new Plc4xReadRequest(requestId, this.connectionId, plc4xTags);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        this.context.sendRequest((Object)plc4xReadRequest).expectResponse(Plc4xMessage.class, this.requestTimeout).onTimeout(future::completeExceptionally).check(plc4xMessage -> plc4xMessage.getRequestId() == requestId).only(Plc4xReadResponse.class).check(plc4xReadResponse -> plc4xReadResponse.getConnectionId() == this.connectionId).handle(plc4xReadResponse -> {
            HashMap<String, ResponseItem> apiResponses = new HashMap<String, ResponseItem>();
            for (Plc4xTagValueResponse plc4xTag : plc4xReadResponse.getTags()) {
                Plc4xResponseCode plc4xResponseCode = plc4xTag.getResponseCode();
                PlcResponseCode apiResponseCode = PlcResponseCode.valueOf((String)plc4xResponseCode.name());
                apiResponses.put(plc4xTag.getTag().getName(), new ResponseItem(apiResponseCode, (Object)plc4xTag.getValue()));
            }
            future.complete((PlcReadResponse)new DefaultPlcReadResponse(apiReadRequest, apiResponses));
            transaction.endRequest();
        });
        return future;
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        ArrayList<Plc4xTagValueRequest> tags = new ArrayList<Plc4xTagValueRequest>(writeRequest.getNumberOfTags());
        for (String tagName : writeRequest.getTagNames()) {
            Plc4xTag plc4xTag = (Plc4xTag)writeRequest.getTag(tagName);
            Plc4xValueType plc4xValueType = Plc4xValueType.valueOf(plc4xTag.getPlcValueType().name());
            PlcValue plcValue = writeRequest.getPlcValue(tagName);
            Plc4xTagValueRequest tagRequest = new Plc4xTagValueRequest(new org.apache.plc4x.java.plc4x.readwrite.Plc4xTag(tagName, String.valueOf(plc4xTag.getAddressString()) + ":" + plc4xTag.getPlcValueType().name()), plc4xValueType, plcValue);
            tags.add(tagRequest);
        }
        int requestId = this.txIdGenerator.getAndIncrement();
        Plc4xWriteRequest write = new Plc4xWriteRequest(requestId, this.connectionId, tags);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        this.context.sendRequest((Object)write).expectResponse(Plc4xMessage.class, this.requestTimeout).onTimeout(future::completeExceptionally).check(p -> p.getRequestId() == requestId).only(Plc4xWriteResponse.class).check(plc4xReadResponse -> plc4xReadResponse.getConnectionId() == this.connectionId).handle(plc4xWriteResponse -> {
            HashMap<String, PlcResponseCode> apiResponses = new HashMap<String, PlcResponseCode>();
            for (Plc4xTagResponse plc4xTag : plc4xWriteResponse.getTags()) {
                Plc4xResponseCode plc4xResponseCode = plc4xTag.getResponseCode();
                PlcResponseCode apiResponseCode = PlcResponseCode.valueOf((String)plc4xResponseCode.name());
                apiResponses.put(plc4xTag.getTag().getName(), apiResponseCode);
            }
            future.complete((PlcWriteResponse)new DefaultPlcWriteResponse(writeRequest, apiResponses));
            transaction.endRequest();
        });
        return future;
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        return super.subscribe(subscriptionRequest);
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        return super.unsubscribe(unsubscriptionRequest);
    }

    protected void decode(ConversationContext<Plc4xMessage> context, Plc4xMessage msg) throws Exception {
        super.decode(context, (Object)msg);
    }
}

