/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.plc4x.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xConnectRequest;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xConnectResponse;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xReadRequest;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xReadResponse;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xRequestType;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xWriteRequest;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xWriteResponse;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class Plc4xMessage
implements Message {
    public static final Short VERSION = 1;
    protected final int requestId;

    public abstract Plc4xRequestType getRequestType();

    public Plc4xMessage(int requestId) {
        this.requestId = requestId;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public short getVersion() {
        return VERSION;
    }

    protected abstract void serializePlc4xMessageChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Plc4xMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"version", (Object)VERSION, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int packetLength = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField((String)"packetLength", (Object)packetLength, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"requestId", (Object)this.requestId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeDiscriminatorEnumField((String)"requestType", (String)"Plc4xRequestType", (Object)((Object)this.getRequestType()), (DataWriter)new DataWriterEnumDefault(Plc4xRequestType::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        this.serializePlc4xMessageChild(writeBuffer);
        writeBuffer.popContext("Plc4xMessage", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        Plc4xMessage _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        return lengthInBits += 8;
    }

    public static Plc4xMessage staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return Plc4xMessage.staticParse(readBuffer);
    }

    public static Plc4xMessage staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("Plc4xMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short version = (Short)FieldReaderFactory.readConstField((String)"version", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (Object)VERSION, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int packetLength = (Integer)FieldReaderFactory.readImplicitField((String)"packetLength", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int requestId = (Integer)FieldReaderFactory.readSimpleField((String)"requestId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        Plc4xRequestType requestType = (Plc4xRequestType)((Object)FieldReaderFactory.readDiscriminatorEnumField((String)"requestType", (String)"Plc4xRequestType", (DataReader)new DataReaderEnumDefault(Plc4xRequestType::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)}));
        Plc4xMessageBuilder builder = null;
        if (EvaluationHelper.equals((Object)((Object)requestType), (Object)((Object)Plc4xRequestType.CONNECT_REQUEST))) {
            builder = Plc4xConnectRequest.staticParsePlc4xMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)((Object)requestType), (Object)((Object)Plc4xRequestType.CONNECT_RESPONSE))) {
            builder = Plc4xConnectResponse.staticParsePlc4xMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)((Object)requestType), (Object)((Object)Plc4xRequestType.READ_REQUEST))) {
            builder = Plc4xReadRequest.staticParsePlc4xMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)((Object)requestType), (Object)((Object)Plc4xRequestType.READ_RESPONSE))) {
            builder = Plc4xReadResponse.staticParsePlc4xMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)((Object)requestType), (Object)((Object)Plc4xRequestType.WRITE_REQUEST))) {
            builder = Plc4xWriteRequest.staticParsePlc4xMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)((Object)requestType), (Object)((Object)Plc4xRequestType.WRITE_RESPONSE))) {
            builder = Plc4xWriteResponse.staticParsePlc4xMessageBuilder(readBuffer);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [requestType=" + (Object)((Object)requestType) + "]");
        }
        readBuffer.closeContext("Plc4xMessage", new WithReaderArgs[0]);
        Plc4xMessage _plc4xMessage = builder.build(requestId);
        return _plc4xMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plc4xMessage)) {
            return false;
        }
        Plc4xMessage that = (Plc4xMessage)o;
        return this.getRequestId() == that.getRequestId();
    }

    public int hashCode() {
        return Objects.hash(this.getRequestId());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface Plc4xMessageBuilder {
        public Plc4xMessage build(int var1);
    }
}

