/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.plc4x.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xMessage;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xRequestType;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xTagRequest;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class Plc4xReadRequest
extends Plc4xMessage
implements Message {
    protected final int connectionId;
    protected final List<Plc4xTagRequest> tags;

    @Override
    public Plc4xRequestType getRequestType() {
        return Plc4xRequestType.READ_REQUEST;
    }

    public Plc4xReadRequest(int requestId, int connectionId, List<Plc4xTagRequest> tags) {
        super(requestId);
        this.connectionId = connectionId;
        this.tags = tags;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public List<Plc4xTagRequest> getTags() {
        return this.tags;
    }

    @Override
    protected void serializePlc4xMessageChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Plc4xReadRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"connectionId", (Object)this.connectionId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        short numTags = (short)StaticHelper.COUNT(this.getTags());
        FieldWriterFactory.writeImplicitField((String)"numTags", (Object)numTags, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeComplexTypeArrayField((String)"tags", this.tags, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        writeBuffer.popContext("Plc4xReadRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        Plc4xReadRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 8;
        if (this.tags != null) {
            int i = 0;
            for (Plc4xTagRequest element : this.tags) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.tags.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static Plc4xMessage.Plc4xMessageBuilder staticParsePlc4xMessageBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("Plc4xReadRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int connectionId = (Integer)FieldReaderFactory.readSimpleField((String)"connectionId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        short numTags = (Short)FieldReaderFactory.readImplicitField((String)"numTags", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        List tags = FieldReaderFactory.readCountArrayField((String)"tags", (DataReader)new DataReaderComplexDefault(() -> Plc4xTagRequest.staticParse(readBuffer), readBuffer), (long)numTags, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("Plc4xReadRequest", new WithReaderArgs[0]);
        return new Plc4xReadRequestBuilderImpl(connectionId, tags);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plc4xReadRequest)) {
            return false;
        }
        Plc4xReadRequest that = (Plc4xReadRequest)o;
        return this.getConnectionId() == that.getConnectionId() && this.getTags() == that.getTags() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getConnectionId(), this.getTags());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class Plc4xReadRequestBuilderImpl
    implements Plc4xMessage.Plc4xMessageBuilder {
        private final int connectionId;
        private final List<Plc4xTagRequest> tags;

        public Plc4xReadRequestBuilderImpl(int connectionId, List<Plc4xTagRequest> tags) {
            this.connectionId = connectionId;
            this.tags = tags;
        }

        @Override
        public Plc4xReadRequest build(int requestId) {
            Plc4xReadRequest plc4xReadRequest = new Plc4xReadRequest(requestId, this.connectionId, this.tags);
            return plc4xReadRequest;
        }
    }
}

