/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.plc4x.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xMessage;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xRequestType;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xResponseCode;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xTagValueResponse;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class Plc4xReadResponse
extends Plc4xMessage
implements Message {
    protected final int connectionId;
    protected final Plc4xResponseCode responseCode;
    protected final List<Plc4xTagValueResponse> tags;

    @Override
    public Plc4xRequestType getRequestType() {
        return Plc4xRequestType.READ_RESPONSE;
    }

    public Plc4xReadResponse(int requestId, int connectionId, Plc4xResponseCode responseCode, List<Plc4xTagValueResponse> tags) {
        super(requestId);
        this.connectionId = connectionId;
        this.responseCode = responseCode;
        this.tags = tags;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public Plc4xResponseCode getResponseCode() {
        return this.responseCode;
    }

    public List<Plc4xTagValueResponse> getTags() {
        return this.tags;
    }

    @Override
    protected void serializePlc4xMessageChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Plc4xReadResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"connectionId", (Object)this.connectionId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleEnumField((String)"responseCode", (String)"Plc4xResponseCode", (Object)((Object)this.responseCode), (DataWriter)new DataWriterEnumDefault(Plc4xResponseCode::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        short numTags = (short)StaticHelper.COUNT(this.getTags());
        FieldWriterFactory.writeImplicitField((String)"numTags", (Object)numTags, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeComplexTypeArrayField((String)"tags", this.tags, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        writeBuffer.popContext("Plc4xReadResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        Plc4xReadResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 8;
        lengthInBits += 8;
        if (this.tags != null) {
            int i = 0;
            for (Plc4xTagValueResponse element : this.tags) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.tags.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static Plc4xMessage.Plc4xMessageBuilder staticParsePlc4xMessageBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("Plc4xReadResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int connectionId = (Integer)FieldReaderFactory.readSimpleField((String)"connectionId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        Plc4xResponseCode responseCode = (Plc4xResponseCode)((Object)FieldReaderFactory.readEnumField((String)"responseCode", (String)"Plc4xResponseCode", (DataReader)new DataReaderEnumDefault(Plc4xResponseCode::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)}));
        short numTags = (Short)FieldReaderFactory.readImplicitField((String)"numTags", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        List tags = FieldReaderFactory.readCountArrayField((String)"tags", (DataReader)new DataReaderComplexDefault(() -> Plc4xTagValueResponse.staticParse(readBuffer), readBuffer), (long)numTags, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("Plc4xReadResponse", new WithReaderArgs[0]);
        return new Plc4xReadResponseBuilderImpl(connectionId, responseCode, tags);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plc4xReadResponse)) {
            return false;
        }
        Plc4xReadResponse that = (Plc4xReadResponse)o;
        return this.getConnectionId() == that.getConnectionId() && this.getResponseCode() == that.getResponseCode() && this.getTags() == that.getTags() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getConnectionId(), this.getResponseCode(), this.getTags()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class Plc4xReadResponseBuilderImpl
    implements Plc4xMessage.Plc4xMessageBuilder {
        private final int connectionId;
        private final Plc4xResponseCode responseCode;
        private final List<Plc4xTagValueResponse> tags;

        public Plc4xReadResponseBuilderImpl(int connectionId, Plc4xResponseCode responseCode, List<Plc4xTagValueResponse> tags) {
            this.connectionId = connectionId;
            this.responseCode = responseCode;
            this.tags = tags;
        }

        @Override
        public Plc4xReadResponse build(int requestId) {
            Plc4xReadResponse plc4xReadResponse = new Plc4xReadResponse(requestId, this.connectionId, this.responseCode, this.tags);
            return plc4xReadResponse;
        }
    }
}

