/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.plc4x.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xMessage;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xRequestType;
import org.apache.plc4x.java.plc4x.readwrite.Plc4xTagValueRequest;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class Plc4xWriteRequest
extends Plc4xMessage
implements Message {
    protected final int connectionId;
    protected final List<Plc4xTagValueRequest> tags;

    @Override
    public Plc4xRequestType getRequestType() {
        return Plc4xRequestType.WRITE_REQUEST;
    }

    public Plc4xWriteRequest(int requestId, int connectionId, List<Plc4xTagValueRequest> tags) {
        super(requestId);
        this.connectionId = connectionId;
        this.tags = tags;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public List<Plc4xTagValueRequest> getTags() {
        return this.tags;
    }

    @Override
    protected void serializePlc4xMessageChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Plc4xWriteRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"connectionId", (Object)this.connectionId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        short numTags = (short)StaticHelper.COUNT(this.getTags());
        FieldWriterFactory.writeImplicitField((String)"numTags", (Object)numTags, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeComplexTypeArrayField((String)"tags", this.tags, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        writeBuffer.popContext("Plc4xWriteRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        Plc4xWriteRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 8;
        if (this.tags != null) {
            int i = 0;
            for (Plc4xTagValueRequest element : this.tags) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.tags.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static Plc4xMessage.Plc4xMessageBuilder staticParsePlc4xMessageBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("Plc4xWriteRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int connectionId = (Integer)FieldReaderFactory.readSimpleField((String)"connectionId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        short numTags = (Short)FieldReaderFactory.readImplicitField((String)"numTags", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        List tags = FieldReaderFactory.readCountArrayField((String)"tags", (DataReader)new DataReaderComplexDefault(() -> Plc4xTagValueRequest.staticParse(readBuffer), readBuffer), (long)numTags, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("Plc4xWriteRequest", new WithReaderArgs[0]);
        return new Plc4xWriteRequestBuilderImpl(connectionId, tags);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plc4xWriteRequest)) {
            return false;
        }
        Plc4xWriteRequest that = (Plc4xWriteRequest)o;
        return this.getConnectionId() == that.getConnectionId() && this.getTags() == that.getTags() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getConnectionId(), this.getTags());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class Plc4xWriteRequestBuilderImpl
    implements Plc4xMessage.Plc4xMessageBuilder {
        private final int connectionId;
        private final List<Plc4xTagValueRequest> tags;

        public Plc4xWriteRequestBuilderImpl(int connectionId, List<Plc4xTagValueRequest> tags) {
            this.connectionId = connectionId;
            this.tags = tags;
        }

        @Override
        public Plc4xWriteRequest build(int requestId) {
            Plc4xWriteRequest plc4xWriteRequest = new Plc4xWriteRequest(requestId, this.connectionId, this.tags);
            return plc4xWriteRequest;
        }
    }
}

