/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet;

import io.netty.buffer.ByteBuf;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.profinet.channel.ProfinetChannel;
import org.apache.plc4x.java.profinet.config.ProfinetConfiguration;
import org.apache.plc4x.java.profinet.config.ProfinetRawSocketTransportConfiguration;
import org.apache.plc4x.java.profinet.context.ProfinetDriverContext;
import org.apache.plc4x.java.profinet.discovery.ProfinetDiscoverer;
import org.apache.plc4x.java.profinet.protocol.ProfinetProtocolLogic;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_Frame;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_FramePayload_PnDcp;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_FramePayload_VirtualLan;
import org.apache.plc4x.java.profinet.readwrite.MacAddress;
import org.apache.plc4x.java.profinet.readwrite.PcDcp_GetSet_Pdu;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block_IpParameter;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_FrameId;
import org.apache.plc4x.java.profinet.readwrite.VirtualLanPriority;
import org.apache.plc4x.java.profinet.tag.ProfinetTag;
import org.apache.plc4x.java.profinet.tag.ProfinetTagHandler;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryRequest;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleTagOptimizer;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapIpV4Address;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfinetDriver
extends GeneratedDriverBase<Ethernet_Frame> {
    private final Logger logger = LoggerFactory.getLogger(ProfinetDriver.class);
    public static final Pattern MAC_ADDRESS = Pattern.compile("^([0-9A-Fa-f]{2}:){5}([0-9A-Fa-f]{2})?");
    public static final String DRIVER_CODE = "profinet";

    public String getProtocolCode() {
        return DRIVER_CODE;
    }

    public String getProtocolName() {
        return "Profinet";
    }

    public PlcDiscoveryRequest.Builder discoveryRequestBuilder() {
        try {
            ProfinetChannel channel = new ProfinetChannel(Pcaps.findAllDevs());
            ProfinetDiscoverer discoverer = new ProfinetDiscoverer(channel);
            return new DefaultPlcDiscoveryRequest.Builder((PlcDiscoverer)discoverer);
        }
        catch (PcapNativeException e) {
            throw new RuntimeException(e);
        }
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return ProfinetConfiguration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "raw": {
                return Optional.of(ProfinetRawSocketTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("raw");
    }

    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("raw");
    }

    protected boolean awaitSetupComplete() {
        return true;
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected boolean canRead() {
        return false;
    }

    protected boolean canWrite() {
        return false;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected boolean canBrowse() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new SingleTagOptimizer();
    }

    protected ProfinetTagHandler getTagHandler() {
        return new ProfinetTagHandler();
    }

    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler();
    }

    protected ProtocolStackConfigurer<Ethernet_Frame> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(Ethernet_Frame.class, (readBuffer, objectArray) -> Ethernet_Frame.staticParse(readBuffer, objectArray)).withProtocol(ProfinetProtocolLogic.class).withDriverContext(ProfinetDriverContext.class).build();
    }

    public ProfinetTag prepareTag(String query) {
        return ProfinetTag.of(query);
    }

    public PlcConnection getConnection(String connectionString, PlcAuthentication authentication) throws PlcConnectionException {
        Matcher matcher = URI_PATTERN.matcher(connectionString);
        if (!matcher.matches()) {
            throw new PlcConnectionException("Connection string doesn't match the format '{protocol-code}:({transport-code})?//{transport-config}(?{parameter-string)?'");
        }
        String protocolCode = matcher.group("protocolCode");
        String transportCodeMatch = matcher.group("transportCode");
        String transportCode = transportCodeMatch != null ? transportCodeMatch : this.getDefaultTransportCode().get();
        String transportConfig = matcher.group("transportConfig");
        String paramString = matcher.group("paramString");
        Matcher macMatcher = MAC_ADDRESS.matcher(transportConfig);
        if (macMatcher.matches()) {
            ProfinetConfiguration configuration;
            block21: {
                this.logger.info("Setting remote PROFINET device IP using DCP");
                ConfigurationFactory configurationFactory = new ConfigurationFactory();
                configuration = (ProfinetConfiguration)configurationFactory.createConfiguration(this.getConfigurationClass(), protocolCode, transportCode, transportConfig, paramString);
                if (configuration == null) {
                    throw new PlcConnectionException("Unsupported configuration");
                }
                if (configuration.ipAddress == null) {
                    throw new PlcConnectionException("When using mac-address connection string, the parameter 'ip-address' is required");
                }
                try {
                    Inet4Address inet4Address = (Inet4Address)Inet4Address.getByName(configuration.ipAddress);
                    for (PcapNetworkInterface dev : Pcaps.findAllDevs()) {
                        if (dev.isLoopBack()) continue;
                        for (PcapAddress curAddress : dev.getAddresses()) {
                            SubnetUtils.SubnetInfo subnetInfo;
                            if (curAddress.getAddress() == null || curAddress.getNetmask() == null || !(curAddress instanceof PcapIpV4Address) || !(subnetInfo = new SubnetUtils(curAddress.getAddress().getHostAddress(), curAddress.getNetmask().getHostAddress()).getInfo()).isInRange(inet4Address.getHostAddress())) continue;
                            ProfinetRawSocketTransportConfiguration profinetRawSocketTransportConfiguration = new ProfinetRawSocketTransportConfiguration();
                            InetSocketAddress remoteAddress = new InetSocketAddress(configuration.ipAddress, profinetRawSocketTransportConfiguration.getDefaultPort());
                            org.pcap4j.util.MacAddress remoteMacAddress = org.pcap4j.util.MacAddress.getByName((String)transportConfig);
                            org.pcap4j.util.MacAddress localMacAddress = dev.getLinkLayerAddresses().stream().filter(linkLayerAddress -> linkLayerAddress instanceof org.pcap4j.util.MacAddress).map(linkLayerAddress -> (org.pcap4j.util.MacAddress)linkLayerAddress).findFirst().orElse(null);
                            byte[] byArray = new byte[4];
                            byArray[0] = -1;
                            byArray[1] = -1;
                            byArray[2] = -1;
                            Ethernet_Frame frame = new Ethernet_Frame(new MacAddress(remoteMacAddress.getAddress()), new MacAddress(localMacAddress.getAddress()), new Ethernet_FramePayload_VirtualLan(VirtualLanPriority.INTERNETWORK_CONTROL, false, 0, new Ethernet_FramePayload_PnDcp(new PcDcp_GetSet_Pdu(PnDcp_FrameId.DCP_GetSet_PDU.getValue(), false, false, 0x10000001L, Collections.singletonList(new PnDcp_Block_IpParameter(false, false, true, remoteAddress.getAddress().getAddress(), byArray, new byte[4]))))));
                            try {
                                Throwable throwable = null;
                                Object var24_27 = null;
                                try (PcapHandle handle = dev.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);){
                                    handle.setFilter("(ether proto 0x8892) and (ether dst " + Pcaps.toBpfString((org.pcap4j.util.MacAddress)localMacAddress) + ") and (ether src " + Pcaps.toBpfString((org.pcap4j.util.MacAddress)remoteMacAddress) + ")", BpfProgram.BpfCompileMode.OPTIMIZE);
                                    WriteBufferByteBased buffer = new WriteBufferByteBased(frame.getLengthInBytes());
                                    try {
                                        frame.serialize((WriteBuffer)buffer);
                                        EthernetPacket packet2 = EthernetPacket.newPacket((byte[])buffer.getBytes(), (int)0, (int)frame.getLengthInBytes());
                                        handle.sendPacket((Packet)packet2);
                                    }
                                    catch (SerializationException | NotOpenException | PcapNativeException | IllegalRawDataException e) {
                                        throw new RuntimeException(e);
                                    }
                                    CompletableFuture future = new CompletableFuture();
                                    handle.loop(1, packet -> {
                                        try {
                                            Ethernet_FramePayload_PnDcp payloadPnDcp;
                                            ReadBufferByteBased readBuffer = new ReadBufferByteBased(packet.getRawData());
                                            Ethernet_Frame ethernetFrame = Ethernet_Frame.staticParse((ReadBuffer)readBuffer);
                                            if (ethernetFrame.getPayload() instanceof Ethernet_FramePayload_PnDcp && (payloadPnDcp = (Ethernet_FramePayload_PnDcp)ethernetFrame.getPayload()).getPdu() instanceof PcDcp_GetSet_Pdu) {
                                                future.complete(true);
                                                return;
                                            }
                                            future.completeExceptionally((Throwable)new PlcConnectionException("Unexpected response"));
                                        }
                                        catch (ParseException e) {
                                            future.completeExceptionally((Throwable)new PlcConnectionException("Error setting ip address", (Throwable)e));
                                        }
                                    });
                                    future.get(1000L, TimeUnit.MILLISECONDS);
                                    this.logger.info("Finished setting remote PROFINET device IP");
                                    break block21;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (InterruptedException | ExecutionException | TimeoutException e) {
                                throw new PlcConnectionException((Throwable)e);
                            }
                        }
                    }
                }
                catch (UnknownHostException | NotOpenException | PcapNativeException e) {
                    throw new PlcConnectionException(e);
                }
            }
            return super.getConnection(String.format("%s:%s://%s?%s", protocolCode, transportCode, configuration.ipAddress, paramString), authentication);
        }
        return super.getConnection(connectionString, authentication);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 6) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 4) + 6;
            }
            return -1;
        }
    }
}

