/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.config;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.plc4x.java.profinet.gsdml.ProfinetISO15745Profile;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.Required;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.StringDefaultValue;

public class ProfinetConfiguration
implements PlcConnectionConfiguration {
    @Required
    @ConfigurationParameter(value="gsd-directory")
    @StringDefaultValue(value="~/.gsd")
    public String gsdDirectory;
    @ConfigurationParameter(value="dap-id")
    public String dapId;
    @ConfigurationParameter(value="ip-address")
    public String ipAddress;

    public ProfinetISO15745Profile getGsdProfile(int vendorId, int deviceId) {
        String value = this.gsdDirectory;
        if (value.startsWith("~")) {
            String homeDirectory = System.getProperty("user.home");
            value = value.replaceAll("~", homeDirectory);
        }
        DirectoryStream<Path> stream = null;
        try {
            stream = Files.newDirectoryStream(Paths.get(value, new String[0]));
            XmlMapper xmlMapper = new XmlMapper();
            for (Path file : stream) {
                try {
                    ProfinetISO15745Profile gsdFile = (ProfinetISO15745Profile)xmlMapper.readValue(file.toFile(), ProfinetISO15745Profile.class);
                    if (gsdFile.getProfileHeader() == null || !gsdFile.getProfileHeader().getProfileIdentification().equals("PROFINET Device Profile") || !gsdFile.getProfileHeader().getProfileClassID().equals("Device")) continue;
                    int curVendorId = Integer.parseInt(gsdFile.getProfileBody().getDeviceIdentity().getVendorId().substring(2), 16);
                    int curDeviceId = Integer.parseInt(gsdFile.getProfileBody().getDeviceIdentity().getDeviceID().substring(2), 16);
                    if (curVendorId != vendorId || curDeviceId != deviceId) continue;
                    ProfinetISO15745Profile profinetISO15745Profile = gsdFile;
                    return profinetISO15745Profile;
                }
                catch (IOException iOException) {
                    try {
                    }
                    catch (IOException e) {
                        throw new RuntimeException("GSDML File directory is un-readable");
                    }
                }
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

