/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.context;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.profinet.gsdml.ProfinetDeviceAccessPointItem;
import org.apache.plc4x.java.profinet.gsdml.ProfinetModuleItem;
import org.apache.plc4x.java.profinet.gsdml.ProfinetVirtualSubmoduleItem;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_ActivityUuid;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_ObjectUuid;
import org.apache.plc4x.java.profinet.readwrite.MacAddress;
import org.apache.plc4x.java.profinet.readwrite.Uuid;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;

public class ProfinetDriverContext
implements DriverContext {
    public static final int DEFAULT_UDP_PORT = 34964;
    public static final int DEFAULT_ARGS_MAXIMUM = 16696;
    public static final int DEFAULT_MAX_ARRAY_COUNT = 16696;
    public static final int DEFAULT_ACTIVITY_TIMEOUT = 600;
    public static final int UDP_RT_PORT = 34962;
    public static final short BLOCK_VERSION_HIGH = 1;
    public static final short BLOCK_VERSION_LOW = 0;
    public static final MacAddress DEFAULT_EMPTY_MAC_ADDRESS;
    public static final int DEFAULT_IO_DATA_SIZE = 40;
    private String deviceType;
    private String deviceName;
    private List<String> roles;
    private int vendorId;
    private int deviceId;
    private boolean advancedStartupMode = true;
    private int sessionKey = 1;
    private int sendClockFactor = 32;
    private int reductionRatio = 16;
    private int watchdogFactor = 3;
    private int dataHoldFactor = 3;
    private ProfinetDeviceAccessPointItem dap;
    private Map<Integer, ProfinetModuleItem> moduleIndex;
    private Map<Integer, Map<Integer, ProfinetVirtualSubmoduleItem>> submoduleIndex;
    private int localPort = 34964;
    private int remotePortImplicitCommunication = 34964;
    private final DceRpc_ActivityUuid activityUuid = ProfinetDriverContext.generateActivityUuid();
    private final Uuid applicationRelationUuid = ProfinetDriverContext.generateApplicationRelationUuid();
    private final AtomicInteger identificationGenerator = new AtomicInteger(1);

    static {
        try {
            DEFAULT_EMPTY_MAC_ADDRESS = new MacAddress(Hex.decodeHex((String)"000000000000"));
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    public static DceRpc_ActivityUuid generateActivityUuid() {
        UUID number = UUID.randomUUID();
        try {
            WriteBufferByteBased wb = new WriteBufferByteBased(128);
            wb.writeLong(64, number.getMostSignificantBits(), new WithWriterArgs[0]);
            wb.writeLong(64, number.getLeastSignificantBits(), new WithWriterArgs[0]);
            ReadBufferByteBased rb = new ReadBufferByteBased(wb.getBytes());
            return new DceRpc_ActivityUuid(rb.readLong(32, new WithReaderArgs[0]), rb.readInt(16, new WithReaderArgs[0]), rb.readInt(16, new WithReaderArgs[0]), rb.readByteArray(8, new WithReaderArgs[0]));
        }
        catch (ParseException | SerializationException throwable) {
            return null;
        }
    }

    protected static Uuid generateApplicationRelationUuid() {
        try {
            return new Uuid(Hex.decodeHex((String)UUID.randomUUID().toString().replace("-", "")));
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(int vendorId) {
        this.vendorId = vendorId;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public boolean isAdvancedStartupMode() {
        return this.advancedStartupMode;
    }

    public void setAdvancedSStartupMode(boolean advancedStartupMode) {
        this.advancedStartupMode = advancedStartupMode;
    }

    public int getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(int sessionKey) {
        this.sessionKey = sessionKey;
    }

    public int getSendClockFactor() {
        return this.sendClockFactor;
    }

    public void setSendClockFactor(int sendClockFactor) {
        this.sendClockFactor = sendClockFactor;
    }

    public int getReductionRatio() {
        return this.reductionRatio;
    }

    public void setReductionRatio(int reductionRatio) {
        this.reductionRatio = reductionRatio;
    }

    public int getWatchdogFactor() {
        return this.watchdogFactor;
    }

    public void setWatchdogFactor(int watchdogFactor) {
        this.watchdogFactor = watchdogFactor;
    }

    public int getDataHoldFactor() {
        return this.dataHoldFactor;
    }

    public void setDataHoldFactor(int dataHoldFactor) {
        this.dataHoldFactor = dataHoldFactor;
    }

    public ProfinetDeviceAccessPointItem getDap() {
        return this.dap;
    }

    public void setDap(ProfinetDeviceAccessPointItem dap) {
        this.dap = dap;
    }

    public Map<Integer, ProfinetModuleItem> getModuleIndex() {
        return this.moduleIndex;
    }

    public void setModuleIndex(Map<Integer, ProfinetModuleItem> moduleIndex) {
        this.moduleIndex = moduleIndex;
    }

    public Map<Integer, Map<Integer, ProfinetVirtualSubmoduleItem>> getSubmoduleIndex() {
        return this.submoduleIndex;
    }

    public void setSubmoduleIndex(Map<Integer, Map<Integer, ProfinetVirtualSubmoduleItem>> submoduleIndex) {
        this.submoduleIndex = submoduleIndex;
    }

    public DceRpc_ActivityUuid getActivityUuid() {
        return this.activityUuid;
    }

    public Uuid getApplicationRelationUuid() {
        return this.applicationRelationUuid;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getRemotePortImplicitCommunication() {
        return this.remotePortImplicitCommunication;
    }

    public int getAndIncrementIdentification() {
        int id = this.identificationGenerator.getAndIncrement();
        if (id == 65535) {
            this.identificationGenerator.set(1);
        }
        return id;
    }

    public DceRpc_ObjectUuid getCmInitiatorObjectUuid() {
        return new DceRpc_ObjectUuid(0, 1, this.getDeviceId(), this.getVendorId());
    }

    public Uuid generateUuid() {
        try {
            return new Uuid(Hex.decodeHex((String)UUID.randomUUID().toString().replace("-", "")));
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }
}

