/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.gsdml;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.List;
import org.apache.plc4x.java.profinet.gsdml.ProfinetDataItem;
import org.apache.plc4x.java.profinet.gsdml.ProfinetDeviceItem;
import org.apache.plc4x.java.profinet.gsdml.ProfinetIoDataInput;
import org.apache.plc4x.java.profinet.gsdml.ProfinetIoDataOutput;
import org.apache.plc4x.java.profinet.gsdml.ProfinetModuleInfo;
import org.apache.plc4x.java.profinet.gsdml.ProfinetSystemDefinedSubmoduleList;
import org.apache.plc4x.java.profinet.gsdml.ProfinetVirtualSubmoduleItem;
import org.apache.plc4x.java.profinet.readwrite.ProfinetDataType;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="ModuleItem")
public class ProfinetModuleItem
implements ProfinetDeviceItem {
    @JacksonXmlProperty(isAttribute=true, localName="ID")
    private String id;
    @JacksonXmlProperty(isAttribute=true, localName="ModuleIdentNumber")
    private String moduleIdentNumber;
    @JacksonXmlProperty(localName="ModuleInfo")
    private ProfinetModuleInfo moduleInfo;
    @JacksonXmlProperty(localName="VirtualSubmoduleList")
    private List<ProfinetVirtualSubmoduleItem> virtualSubmoduleList;

    public String getId() {
        return this.id;
    }

    @Override
    public String getModuleIdentNumber() {
        return this.moduleIdentNumber;
    }

    public ProfinetModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    @Override
    public List<ProfinetVirtualSubmoduleItem> getVirtualSubmoduleList() {
        return this.virtualSubmoduleList;
    }

    @Override
    public ProfinetSystemDefinedSubmoduleList getSystemDefinedSubmoduleList() {
        return null;
    }

    private static int getLengthSimpleType(String dataType) {
        ProfinetDataType dt = ProfinetDataType.firstEnumForFieldConversion(dataType.toUpperCase());
        if (dt == null) {
            throw new UnsupportedOperationException("Data type " + dataType + " not supported");
        }
        return dt.getDataTypeSize();
    }

    @Override
    public Integer getInputDataLength() {
        int length = 0;
        for (ProfinetVirtualSubmoduleItem module : this.virtualSubmoduleList) {
            if (module.getIoData() == null || module.getIoData().getInput() == null) continue;
            for (ProfinetIoDataInput inputIoData : module.getIoData().getInput()) {
                for (ProfinetDataItem dataItem : inputIoData.getDataItemList()) {
                    length += ProfinetModuleItem.getLengthSimpleType(dataItem.getDataType());
                }
            }
        }
        return length;
    }

    @Override
    public Integer getOutputDataLength() {
        int length = 0;
        for (ProfinetVirtualSubmoduleItem module : this.virtualSubmoduleList) {
            if (module.getIoData() == null || module.getIoData().getOutput() == null) continue;
            for (ProfinetIoDataOutput outputIoData : module.getIoData().getOutput()) {
                for (ProfinetDataItem dataItem : outputIoData.getDataItemList()) {
                    length += ProfinetModuleItem.getLengthSimpleType(dataItem.getDataType());
                }
            }
        }
        return length;
    }
}

