/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.packets;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.profinet.context.ProfinetDriverContext;
import org.apache.plc4x.java.profinet.readwrite.CharacterEncoding;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_ActivityUuid;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_InterfaceUuid_ControllerInterface;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_InterfaceUuid_DeviceInterface;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_ObjectUuid;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_Operation;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_Packet;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_PacketType;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_Frame;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_FramePayload_IPv4;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_FramePayload_PnDcp;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_FramePayload_VirtualLan;
import org.apache.plc4x.java.profinet.readwrite.FloatingPointEncoding;
import org.apache.plc4x.java.profinet.readwrite.IODReadRequestHeader;
import org.apache.plc4x.java.profinet.readwrite.IODReadResponseHeader;
import org.apache.plc4x.java.profinet.readwrite.IntegerEncoding;
import org.apache.plc4x.java.profinet.readwrite.IpAddress;
import org.apache.plc4x.java.profinet.readwrite.MacAddress;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block_ALLSelector;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_FrameId;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Pdu_IdentifyReq;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Pdu_IdentifyRes;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block_IAndM0;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block_IAndM1;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block_RealIdentificationData;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Control_Request_ParameterEnd;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Control_Response_ApplicationReady;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Control_Response_ParameterEnd;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet_Rej;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet_Req;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet_Res;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet_Working;
import org.apache.plc4x.java.profinet.readwrite.Uuid;
import org.apache.plc4x.java.profinet.readwrite.VirtualLanPriority;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.utils.rawsockets.netty.RawSocketChannel;

public class PnDcpPacketFactory {
    public static Ethernet_Frame createIdentificationRequest(MacAddress localMacAddress, MacAddress remoteMacAddress) {
        return new Ethernet_Frame(remoteMacAddress, localMacAddress, new Ethernet_FramePayload_VirtualLan(VirtualLanPriority.BEST_EFFORT, false, 0, new Ethernet_FramePayload_PnDcp(new PnDcp_Pdu_IdentifyReq(PnDcp_FrameId.DCP_Identify_ReqPDU.getValue(), 1L, 256, Collections.singletonList(new PnDcp_Block_ALLSelector())))));
    }

    public static CompletableFuture<PnDcp_Pdu_IdentifyRes> sendIdentificationRequest(ConversationContext<Ethernet_Frame> context, MacAddress localMacAddress, MacAddress remoteMacAddress) {
        CompletableFuture<PnDcp_Pdu_IdentifyRes> future = new CompletableFuture<PnDcp_Pdu_IdentifyRes>();
        context.sendRequest((Object)PnDcpPacketFactory.createIdentificationRequest(localMacAddress, remoteMacAddress)).name("Expect Identification response").expectResponse(Ethernet_Frame.class, Duration.ofMillis(6000L)).onTimeout(future::completeExceptionally).onError((ethernetFrame, throwable) -> {
            boolean bl = future.completeExceptionally((Throwable)throwable);
        }).unwrap(ethernetFrame -> {
            if (ethernetFrame.getPayload() instanceof Ethernet_FramePayload_VirtualLan) {
                return ((Ethernet_FramePayload_VirtualLan)ethernetFrame.getPayload()).getPayload();
            }
            return ethernetFrame.getPayload();
        }).check(ethernetFramePayload -> ethernetFramePayload instanceof Ethernet_FramePayload_PnDcp).only(Ethernet_FramePayload_PnDcp.class).unwrap(Ethernet_FramePayload_PnDcp::getPdu).only(PnDcp_Pdu_IdentifyRes.class).handle(future::complete);
        return future;
    }

    public static Ethernet_Frame createReadIAndM0BlockRequest(RawSocketChannel pnChannel, ProfinetDriverContext driverContext) {
        DceRpc_Packet packet = new DceRpc_Packet(DceRpc_PacketType.REQUEST, true, false, false, IntegerEncoding.LITTLE_ENDIAN, CharacterEncoding.ASCII, FloatingPointEncoding.IEEE, new DceRpc_ObjectUuid(0, 1, driverContext.getDeviceId(), driverContext.getVendorId()), new DceRpc_InterfaceUuid_DeviceInterface(), driverContext.getActivityUuid(), 0L, driverContext.getAndIncrementIdentification(), DceRpc_Operation.READ_IMPLICIT, 0, new PnIoCm_Packet_Req(16696L, 16696L, 0L, Collections.singletonList(new IODReadRequestHeader(1, 0, 0, new Uuid(new byte[16]), 0L, 0, 1, 45040, 16696L, new Uuid(new byte[16])))));
        return PnDcpPacketFactory.createEthernetFrame(pnChannel, driverContext, packet);
    }

    public static CompletableFuture<PnIoCm_Block_IAndM0> sendReadIAndM0BlockRequest(ConversationContext<Ethernet_Frame> context, RawSocketChannel pnChannel, ProfinetDriverContext driverContext) {
        CompletableFuture<PnIoCm_Block_IAndM0> future = new CompletableFuture<PnIoCm_Block_IAndM0>();
        context.sendRequest((Object)PnDcpPacketFactory.createReadIAndM0BlockRequest(pnChannel, driverContext)).name("Expect ReadIAndM0Block response").expectResponse(Ethernet_Frame.class, Duration.ofMillis(6000L)).onTimeout(future::completeExceptionally).onError((ethernetFrame, throwable) -> {
            boolean bl = future.completeExceptionally((Throwable)throwable);
        }).unwrap(ethernetFrame -> {
            if (ethernetFrame.getPayload() instanceof Ethernet_FramePayload_VirtualLan) {
                return ((Ethernet_FramePayload_VirtualLan)ethernetFrame.getPayload()).getPayload();
            }
            return ethernetFrame.getPayload();
        }).only(Ethernet_FramePayload_IPv4.class).unwrap(Ethernet_FramePayload_IPv4::getPayload).unwrap(DceRpc_Packet::getPayload).only(PnIoCm_Packet_Res.class).handle(dceRpcPacketRes -> {
            if (dceRpcPacketRes.getBlocks().size() != 2) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("Expected 2 blocks in the response"));
                return;
            }
            if (!(dceRpcPacketRes.getBlocks().get(0) instanceof IODReadResponseHeader)) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("The first block was expected to be of type IODReadResponseHeader"));
                return;
            }
            if (!(dceRpcPacketRes.getBlocks().get(1) instanceof PnIoCm_Block_IAndM0)) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("The second block was expected to be of type PnIoCm_Block_IAndM0"));
                return;
            }
            PnIoCm_Block_IAndM0 iAndM0 = (PnIoCm_Block_IAndM0)dceRpcPacketRes.getBlocks().get(1);
            future.complete(iAndM0);
        });
        return future;
    }

    public static Ethernet_Frame createReadIAndM1BlockRequest(RawSocketChannel pnChannel, ProfinetDriverContext driverContext) {
        DceRpc_Packet packet = new DceRpc_Packet(DceRpc_PacketType.REQUEST, true, false, false, IntegerEncoding.LITTLE_ENDIAN, CharacterEncoding.ASCII, FloatingPointEncoding.IEEE, new DceRpc_ObjectUuid(0, 1, driverContext.getDeviceId(), driverContext.getVendorId()), new DceRpc_InterfaceUuid_DeviceInterface(), driverContext.getActivityUuid(), 0L, driverContext.getAndIncrementIdentification(), DceRpc_Operation.READ_IMPLICIT, 0, new PnIoCm_Packet_Req(16696L, 16696L, 0L, Collections.singletonList(new IODReadRequestHeader(1, 0, 0, new Uuid(new byte[16]), 0L, 0, 1, 45041, 16696L, new Uuid(new byte[16])))));
        return PnDcpPacketFactory.createEthernetFrame(pnChannel, driverContext, packet);
    }

    public static CompletableFuture<PnIoCm_Block_IAndM1> sendReadIAndM1BlockRequest(ConversationContext<Ethernet_Frame> context, RawSocketChannel pnChannel, ProfinetDriverContext driverContext) {
        CompletableFuture<PnIoCm_Block_IAndM1> future = new CompletableFuture<PnIoCm_Block_IAndM1>();
        context.sendRequest((Object)PnDcpPacketFactory.createReadIAndM1BlockRequest(pnChannel, driverContext)).name("Expect ReadIAndM1Block response").expectResponse(Ethernet_Frame.class, Duration.ofMillis(6000L)).onTimeout(future::completeExceptionally).onError((ethernetFrame, throwable) -> {
            boolean bl = future.completeExceptionally((Throwable)throwable);
        }).unwrap(ethernetFrame -> {
            if (ethernetFrame.getPayload() instanceof Ethernet_FramePayload_VirtualLan) {
                return ((Ethernet_FramePayload_VirtualLan)ethernetFrame.getPayload()).getPayload();
            }
            return ethernetFrame.getPayload();
        }).only(Ethernet_FramePayload_IPv4.class).unwrap(Ethernet_FramePayload_IPv4::getPayload).unwrap(DceRpc_Packet::getPayload).only(PnIoCm_Packet_Res.class).handle(dceRpcPacketRes -> {
            if (dceRpcPacketRes.getBlocks().size() != 2) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("Expected 2 blocks in the response"));
                return;
            }
            if (!(dceRpcPacketRes.getBlocks().get(0) instanceof IODReadResponseHeader)) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("The first block was expected to be of type IODReadResponseHeader"));
                return;
            }
            if (!(dceRpcPacketRes.getBlocks().get(1) instanceof PnIoCm_Block_IAndM1)) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("The second block was expected to be of type PnIoCm_Block_IAndM0"));
                return;
            }
            PnIoCm_Block_IAndM1 iAndM1 = (PnIoCm_Block_IAndM1)dceRpcPacketRes.getBlocks().get(1);
            future.complete(iAndM1);
        });
        return future;
    }

    public static Ethernet_Frame createReadRealIdentificationDataRequest(RawSocketChannel pnChannel, ProfinetDriverContext driverContext) {
        DceRpc_Packet packet = new DceRpc_Packet(DceRpc_PacketType.REQUEST, true, false, false, IntegerEncoding.LITTLE_ENDIAN, CharacterEncoding.ASCII, FloatingPointEncoding.IEEE, new DceRpc_ObjectUuid(0, 1, driverContext.getDeviceId(), driverContext.getVendorId()), new DceRpc_InterfaceUuid_DeviceInterface(), driverContext.getActivityUuid(), 0L, driverContext.getAndIncrementIdentification(), DceRpc_Operation.READ_IMPLICIT, 0, new PnIoCm_Packet_Req(16696L, 16696L, 0L, Collections.singletonList(new IODReadRequestHeader(1, 0, 0, new Uuid(new byte[16]), 0L, 0, 0, 61440, 16696L, new Uuid(new byte[16])))));
        return PnDcpPacketFactory.createEthernetFrame(pnChannel, driverContext, packet);
    }

    public static CompletableFuture<PnIoCm_Block_RealIdentificationData> sendRealIdentificationDataRequest(ConversationContext<Ethernet_Frame> context, RawSocketChannel pnChannel, ProfinetDriverContext driverContext) {
        CompletableFuture<PnIoCm_Block_RealIdentificationData> future = new CompletableFuture<PnIoCm_Block_RealIdentificationData>();
        context.sendRequest((Object)PnDcpPacketFactory.createReadRealIdentificationDataRequest(pnChannel, driverContext)).name("Expect RealIdentificationData response").expectResponse(Ethernet_Frame.class, Duration.ofMillis(6000L)).onTimeout(future::completeExceptionally).onError((ethernetFrame, throwable) -> {
            boolean bl = future.completeExceptionally((Throwable)throwable);
        }).unwrap(ethernetFrame -> {
            if (ethernetFrame.getPayload() instanceof Ethernet_FramePayload_VirtualLan) {
                return ((Ethernet_FramePayload_VirtualLan)ethernetFrame.getPayload()).getPayload();
            }
            return ethernetFrame.getPayload();
        }).only(Ethernet_FramePayload_IPv4.class).unwrap(Ethernet_FramePayload_IPv4::getPayload).unwrap(DceRpc_Packet::getPayload).handle(dceRpcPacket -> {
            if (dceRpcPacket instanceof PnIoCm_Packet_Rej) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("RealIdentificationData not supported"));
                return;
            }
            if (!(dceRpcPacket instanceof PnIoCm_Packet_Res)) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("Unexpected response type"));
                return;
            }
            PnIoCm_Packet_Res dceRpcPacketRes = (PnIoCm_Packet_Res)dceRpcPacket;
            if (dceRpcPacketRes.getBlocks().size() != 2) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("Expected 2 blocks in the response"));
                return;
            }
            if (!(dceRpcPacketRes.getBlocks().get(0) instanceof IODReadResponseHeader)) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("The first block was expected to be of type IODReadResponseHeader"));
                return;
            }
            if (!(dceRpcPacketRes.getBlocks().get(1) instanceof PnIoCm_Block_RealIdentificationData)) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("The second block was expected to be of type PnIoCm_Block_RealIdentificationData"));
                return;
            }
            PnIoCm_Block_RealIdentificationData realIdentificationData = (PnIoCm_Block_RealIdentificationData)dceRpcPacketRes.getBlocks().get(1);
            future.complete(realIdentificationData);
        });
        return future;
    }

    public static Ethernet_Frame createParameterEndRequest(RawSocketChannel pnChannel, ProfinetDriverContext driverContext) {
        DceRpc_Packet packet = new DceRpc_Packet(DceRpc_PacketType.REQUEST, true, false, false, IntegerEncoding.LITTLE_ENDIAN, CharacterEncoding.ASCII, FloatingPointEncoding.IEEE, new DceRpc_ObjectUuid(0, 1, driverContext.getDeviceId(), driverContext.getVendorId()), new DceRpc_InterfaceUuid_DeviceInterface(), driverContext.getActivityUuid(), 0L, driverContext.getAndIncrementIdentification(), DceRpc_Operation.CONTROL, 0, new PnIoCm_Packet_Req(16696L, 16696L, 0L, Collections.singletonList(new PnIoCm_Control_Request_ParameterEnd(1, 0, new Uuid(driverContext.getApplicationRelationUuid().getData()), 1, 1))));
        return PnDcpPacketFactory.createEthernetFrame(pnChannel, driverContext, packet);
    }

    public static CompletableFuture<PnIoCm_Control_Response_ParameterEnd> sendParameterEndRequest(ConversationContext<Ethernet_Frame> context, RawSocketChannel pnChannel, ProfinetDriverContext driverContext) {
        CompletableFuture<PnIoCm_Control_Response_ParameterEnd> future = new CompletableFuture<PnIoCm_Control_Response_ParameterEnd>();
        context.sendRequest((Object)PnDcpPacketFactory.createParameterEndRequest(pnChannel, driverContext)).name("Expect ParameterEnd response").expectResponse(Ethernet_Frame.class, Duration.ofMillis(6000L)).onTimeout(future::completeExceptionally).onError((ethernetFrame, throwable) -> {
            boolean bl = future.completeExceptionally((Throwable)throwable);
        }).unwrap(ethernetFrame -> {
            if (ethernetFrame.getPayload() instanceof Ethernet_FramePayload_VirtualLan) {
                return ((Ethernet_FramePayload_VirtualLan)ethernetFrame.getPayload()).getPayload();
            }
            return ethernetFrame.getPayload();
        }).only(Ethernet_FramePayload_IPv4.class).unwrap(Ethernet_FramePayload_IPv4::getPayload).unwrap(DceRpc_Packet::getPayload).check(pnIoCmPacket -> pnIoCmPacket instanceof PnIoCm_Packet_Rej || pnIoCmPacket instanceof PnIoCm_Packet_Res).handle(dceRpcPacket -> {
            if (dceRpcPacket instanceof PnIoCm_Packet_Rej) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("ParameterEnd not supported"));
                return;
            }
            PnIoCm_Packet_Res dceRpcPacketRes = (PnIoCm_Packet_Res)dceRpcPacket;
            if (dceRpcPacketRes.getBlocks().size() != 1) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("Expected 1 blocks in the response"));
                return;
            }
            if (!(dceRpcPacketRes.getBlocks().get(0) instanceof PnIoCm_Control_Response_ParameterEnd)) {
                future.completeExceptionally((Throwable)new PlcRuntimeException("The block was expected to be of type PnIoCm_Control_Response_ParameterEnd"));
                return;
            }
            PnIoCm_Control_Response_ParameterEnd controlResponse = (PnIoCm_Control_Response_ParameterEnd)dceRpcPacketRes.getBlocks().get(0);
            future.complete(controlResponse);
        });
        return future;
    }

    public static Ethernet_Frame createApplicationReadyResponse(RawSocketChannel pnChannel, ProfinetDriverContext driverContext, int sourcePort, DceRpc_ActivityUuid activityUuid, Uuid arUuid, int sessionKey) {
        DceRpc_Packet packet = new DceRpc_Packet(DceRpc_PacketType.RESPONSE, true, false, false, IntegerEncoding.LITTLE_ENDIAN, CharacterEncoding.ASCII, FloatingPointEncoding.IEEE, new DceRpc_ObjectUuid(0, 1, driverContext.getDeviceId(), driverContext.getVendorId()), new DceRpc_InterfaceUuid_ControllerInterface(), activityUuid, 0L, 0L, DceRpc_Operation.CONTROL, 0, new PnIoCm_Packet_Res(0, 0, 0, 0, 16696L, 0L, Collections.singletonList(new PnIoCm_Control_Response_ApplicationReady(1, 0, arUuid, sessionKey, 8, 0))));
        InetSocketAddress localAddress = (InetSocketAddress)pnChannel.getLocalAddress();
        InetSocketAddress remoteAddress = (InetSocketAddress)pnChannel.getRemoteAddress();
        Random rand = new Random();
        Ethernet_FramePayload_IPv4 udpFrame = new Ethernet_FramePayload_IPv4(rand.nextInt(65536), true, false, 64, new IpAddress(localAddress.getAddress().getAddress()), new IpAddress(remoteAddress.getAddress().getAddress()), driverContext.getLocalPort(), sourcePort, packet);
        MacAddress srcAddress = new MacAddress(pnChannel.getLocalMacAddress().getAddress());
        MacAddress dstAddress = new MacAddress(pnChannel.getRemoteMacAddress().getAddress());
        return new Ethernet_Frame(dstAddress, srcAddress, udpFrame);
    }

    public static void sendApplicationReadyResponse(ConversationContext<Ethernet_Frame> context, RawSocketChannel pnChannel, ProfinetDriverContext driverContext, int sourcePort, DceRpc_ActivityUuid activityUuid, Uuid arUuid, int sessionKey) {
        context.sendToWire((Object)PnDcpPacketFactory.createApplicationReadyResponse(pnChannel, driverContext, sourcePort, activityUuid, arUuid, sessionKey));
    }

    public static Ethernet_Frame createPingResponse(RawSocketChannel pnChannel, ProfinetDriverContext driverContext, Ethernet_FramePayload_IPv4 payloadIPv4) {
        DceRpc_Packet pingRequest = payloadIPv4.getPayload();
        DceRpc_Packet packet = new DceRpc_Packet(DceRpc_PacketType.WORKING, false, false, false, IntegerEncoding.BIG_ENDIAN, CharacterEncoding.ASCII, FloatingPointEncoding.IEEE, pingRequest.getObjectUuid(), pingRequest.getInterfaceUuid(), pingRequest.getActivityUuid(), 0L, 0L, DceRpc_Operation.CONNECT, 0, new PnIoCm_Packet_Working());
        InetSocketAddress localAddress = (InetSocketAddress)pnChannel.getLocalAddress();
        InetSocketAddress remoteAddress = (InetSocketAddress)pnChannel.getRemoteAddress();
        Random rand = new Random();
        Ethernet_FramePayload_IPv4 udpFrame = new Ethernet_FramePayload_IPv4(rand.nextInt(65536), true, false, 64, new IpAddress(localAddress.getAddress().getAddress()), new IpAddress(remoteAddress.getAddress().getAddress()), driverContext.getLocalPort(), payloadIPv4.getSourcePort(), packet);
        MacAddress srcAddress = new MacAddress(pnChannel.getLocalMacAddress().getAddress());
        MacAddress dstAddress = new MacAddress(pnChannel.getRemoteMacAddress().getAddress());
        return new Ethernet_Frame(dstAddress, srcAddress, udpFrame);
    }

    public static void sendPingResponse(ConversationContext<Ethernet_Frame> context, RawSocketChannel pnChannel, ProfinetDriverContext driverContext, Ethernet_FramePayload_IPv4 payloadIPv4) {
        context.sendToWire((Object)PnDcpPacketFactory.createPingResponse(pnChannel, driverContext, payloadIPv4));
    }

    protected static Ethernet_Frame createEthernetFrame(RawSocketChannel pnChannel, ProfinetDriverContext driverContext, DceRpc_Packet packet) {
        InetSocketAddress localAddress = (InetSocketAddress)pnChannel.getLocalAddress();
        InetSocketAddress remoteAddress = (InetSocketAddress)pnChannel.getRemoteAddress();
        Random rand = new Random();
        Ethernet_FramePayload_IPv4 udpFrame = new Ethernet_FramePayload_IPv4(rand.nextInt(65536), true, false, 64, new IpAddress(localAddress.getAddress().getAddress()), new IpAddress(remoteAddress.getAddress().getAddress()), driverContext.getLocalPort(), driverContext.getRemotePortImplicitCommunication(), packet);
        MacAddress srcAddress = new MacAddress(pnChannel.getLocalMacAddress().getAddress());
        MacAddress dstAddress = new MacAddress(pnChannel.getRemoteMacAddress().getAddress());
        return new Ethernet_Frame(dstAddress, srcAddress, udpFrame);
    }
}

