/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.protocol;

import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.profinet.config.ProfinetConfiguration;
import org.apache.plc4x.java.profinet.context.ProfinetDriverContext;
import org.apache.plc4x.java.profinet.gsdml.ProfinetDataItem;
import org.apache.plc4x.java.profinet.gsdml.ProfinetDeviceAccessPointItem;
import org.apache.plc4x.java.profinet.gsdml.ProfinetISO15745Profile;
import org.apache.plc4x.java.profinet.gsdml.ProfinetIoDataInput;
import org.apache.plc4x.java.profinet.gsdml.ProfinetIoDataOutput;
import org.apache.plc4x.java.profinet.gsdml.ProfinetModuleItem;
import org.apache.plc4x.java.profinet.gsdml.ProfinetTextIdValue;
import org.apache.plc4x.java.profinet.gsdml.ProfinetVirtualSubmoduleItem;
import org.apache.plc4x.java.profinet.packets.PnDcpPacketFactory;
import org.apache.plc4x.java.profinet.readwrite.CharacterEncoding;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_InterfaceUuid_DeviceInterface;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_ObjectUuid;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_Operation;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_Packet;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_PacketType;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_Frame;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_FramePayload_IPv4;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_FramePayload_PnDcp;
import org.apache.plc4x.java.profinet.readwrite.FloatingPointEncoding;
import org.apache.plc4x.java.profinet.readwrite.IntegerEncoding;
import org.apache.plc4x.java.profinet.readwrite.IpAddress;
import org.apache.plc4x.java.profinet.readwrite.MacAddress;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block_DevicePropertiesDeviceId;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block_DevicePropertiesDeviceRole;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block_DevicePropertiesDeviceVendor;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block_DevicePropertiesNameOfStation;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Pdu_IdentifyRes;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Pdu_RealTimeCyclic;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_AlarmCrType;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_ArType;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block_AlarmCrReq;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block_ArReq;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block_ExpectedSubmoduleReq;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block_IoCrReq;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block_RealIdentificationData;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_CompanionArType;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Control_Request_ApplicationReady;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Control_Response_ParameterEnd;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_ExpectedSubmoduleBlockReqApi;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_IoCrBlockReqApi;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_IoCrType;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_IoCs;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_IoDataObject;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet_ConnectionlessCancel;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet_Ping;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet_Req;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet_Res;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_RealIdentificationApi;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_RealIdentificationApi_Slot;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_RealIdentificationApi_Subslot;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_RtClass;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_State;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Submodule;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_SubmoduleType;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Submodule_InputAndOutputData;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Submodule_InputData;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Submodule_NoInputNoOutputData;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Submodule_OutputData;
import org.apache.plc4x.java.profinet.readwrite.Uuid;
import org.apache.plc4x.java.profinet.tag.ProfinetTag;
import org.apache.plc4x.java.profinet.utils.ProfinetDataTypeMapper;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseItem;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseResponse;
import org.apache.plc4x.java.utils.rawsockets.netty.RawSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfinetProtocolLogic
extends Plc4xProtocolBase<Ethernet_Frame>
implements HasConfiguration<ProfinetConfiguration> {
    private static final int NANOS_PER_CYCLE = 31250;
    private ProfinetDriverContext profinetDriverContext;
    private ProfinetConfiguration configuration;
    private Integer cycleOffset = null;
    private boolean connected = false;
    private final Logger logger = LoggerFactory.getLogger(ProfinetProtocolLogic.class);

    public void setDriverContext(DriverContext driverContext) {
        super.setDriverContext(driverContext);
        if (!(driverContext instanceof ProfinetDriverContext)) {
            throw new PlcRuntimeException("Expecting a driverContext of type ProfinetDriverContext, but got " + driverContext.getClass().getName());
        }
        this.profinetDriverContext = (ProfinetDriverContext)driverContext;
    }

    public void setConfiguration(ProfinetConfiguration configuration) {
        this.configuration = configuration;
    }

    public void onConnect(ConversationContext<Ethernet_Frame> context) {
        super.onConnect(context);
        RawSocketChannel rawSocketChannel = (RawSocketChannel)context.getChannel();
        MacAddress remoteMacAddress = new MacAddress(rawSocketChannel.getRemoteMacAddress().getAddress());
        MacAddress localMacAddress = new MacAddress(rawSocketChannel.getLocalMacAddress().getAddress());
        CompletableFuture<PnDcp_Pdu_IdentifyRes> future = PnDcpPacketFactory.sendIdentificationRequest(context, localMacAddress, remoteMacAddress);
        future.whenComplete((identifyRes, throwable) -> {
            if (throwable != null) {
                this.logger.error("Unable to determine vendor-id or product-id, closing channel...", throwable);
                context.getChannel().close();
                return;
            }
            this.extractBlockInfo(identifyRes.getBlocks());
            if (this.profinetDriverContext.getVendorId() == 0 || this.profinetDriverContext.getDeviceId() == 0) {
                this.logger.error("Unable to determine vendor-id or product-id, closing channel...");
                context.getChannel().close();
                return;
            }
            ProfinetISO15745Profile deviceProfile = this.configuration.getGsdProfile(this.profinetDriverContext.getVendorId(), this.profinetDriverContext.getDeviceId());
            if (deviceProfile == null) {
                this.logger.error("Unable to find GSD profile for device with vendor-id {} and device-id {}", (Object)this.profinetDriverContext.getVendorId(), (Object)this.profinetDriverContext.getDeviceId());
                context.getChannel().close();
                return;
            }
            if (this.configuration.dapId != null) {
                for (ProfinetDeviceAccessPointItem profinetDeviceAccessPointItem : deviceProfile.getProfileBody().getApplicationProcess().getDeviceAccessPointList()) {
                    if (!profinetDeviceAccessPointItem.getId().equalsIgnoreCase(this.configuration.dapId)) continue;
                    this.profinetDriverContext.setDap(profinetDeviceAccessPointItem);
                    break;
                }
                if (this.profinetDriverContext.getDap() == null) {
                    this.logger.error("Couldn't find requested device access points (DAP): {}", (Object)this.configuration.dapId);
                    context.getChannel().close();
                }
            } else if (deviceProfile.getProfileBody().getApplicationProcess().getDeviceAccessPointList().size() == 1) {
                this.profinetDriverContext.setDap(deviceProfile.getProfileBody().getApplicationProcess().getDeviceAccessPointList().get(0));
            }
            if (!deviceProfile.getProfileBody().getApplicationProcess().getDeviceAccessPointList().isEmpty()) {
                HashMap<String, String> textMapping = new HashMap<String, String>();
                for (ProfinetTextIdValue profinetTextIdValue : deviceProfile.getProfileBody().getApplicationProcess().getExternalTextList().getPrimaryLanguage().getText()) {
                    textMapping.put(profinetTextIdValue.getTextId(), profinetTextIdValue.getValue());
                }
                RawSocketChannel pnChannel = (RawSocketChannel)context.getChannel();
                CompletableFuture<PnIoCm_Block_RealIdentificationData> future1 = PnDcpPacketFactory.sendRealIdentificationDataRequest(context, pnChannel, this.profinetDriverContext);
                future1.whenComplete((realIdentificationData, throwable1) -> {
                    if (throwable1 != null) {
                        if (this.profinetDriverContext.getDap() == null) {
                            this.logger.error("Unable to auto-configure connection, please be sure to provide the 'dap-id' connection parameter");
                            context.getChannel().close();
                            return;
                        }
                        context.fireConnected();
                        return;
                    }
                    HashMap<Integer, Long> slotModuleIdentificationNumbers = new HashMap<Integer, Long>();
                    HashMap subslotModuleIdentificationNumbers = new HashMap();
                    for (PnIoCm_RealIdentificationApi api : realIdentificationData.getApis()) {
                        for (PnIoCm_RealIdentificationApi_Slot curSlot : api.getSlots()) {
                            slotModuleIdentificationNumbers.put(curSlot.getSlotNumber(), curSlot.getModuleIdentNumber());
                            if (!subslotModuleIdentificationNumbers.containsKey(curSlot.getSlotNumber())) {
                                subslotModuleIdentificationNumbers.put(curSlot.getSlotNumber(), new HashMap());
                            }
                            for (PnIoCm_RealIdentificationApi_Subslot curSubslot : curSlot.getSubslots()) {
                                ((Map)subslotModuleIdentificationNumbers.get(curSlot.getSlotNumber())).put(curSubslot.getSubslotNumber(), curSubslot.getSubmoduleIdentNumber());
                            }
                        }
                    }
                    long dapModuleIdentificationNumber = (Long)slotModuleIdentificationNumbers.get(0);
                    if (dapModuleIdentificationNumber == 0L) {
                        this.logger.error("Unable to detect device access point, closing channel...");
                        context.getChannel().close();
                        return;
                    }
                    for (ProfinetDeviceAccessPointItem curDap : deviceProfile.getProfileBody().getApplicationProcess().getDeviceAccessPointList()) {
                        long moduleIdentNumber;
                        String moduleIdentNumberStr = curDap.getModuleIdentNumber();
                        if (moduleIdentNumberStr.startsWith("0x") || moduleIdentNumberStr.startsWith("0X")) {
                            moduleIdentNumberStr = moduleIdentNumberStr.substring(2);
                        }
                        if ((moduleIdentNumber = Long.parseLong(moduleIdentNumberStr, 16)) != dapModuleIdentificationNumber) continue;
                        if (this.profinetDriverContext.getDap() != null && !this.profinetDriverContext.getDap().getId().equals(curDap.getId())) {
                            this.logger.warn("DAP configured in connection string differs from device-configuration.");
                        }
                        this.profinetDriverContext.setDap(curDap);
                        break;
                    }
                    if (this.profinetDriverContext.getDap() == null) {
                        this.logger.error("Unable to auto-detect the device access point, please provide \"dap-id\" option in the connection-string. Closing channel...");
                        context.getChannel().close();
                        return;
                    }
                    HashMap<Integer, ProfinetModuleItem> moduleIndex = new HashMap<Integer, ProfinetModuleItem>();
                    HashMap<Integer, Map<Integer, ProfinetVirtualSubmoduleItem>> submoduleIndex = new HashMap<Integer, Map<Integer, ProfinetVirtualSubmoduleItem>>();
                    for (Map.Entry moduleEntry : slotModuleIdentificationNumbers.entrySet()) {
                        int curSlot = (Integer)moduleEntry.getKey();
                        if (curSlot == 0) continue;
                        long curModuleIdentifier = (Long)moduleEntry.getValue();
                        for (ProfinetModuleItem curModule : deviceProfile.getProfileBody().getApplicationProcess().getModuleList()) {
                            long moduleIdentNumber;
                            String moduleIdentNumberStr = curModule.getModuleIdentNumber();
                            if (moduleIdentNumberStr.startsWith("0x") || moduleIdentNumberStr.startsWith("0X")) {
                                moduleIdentNumberStr = moduleIdentNumberStr.substring(2);
                            }
                            if (curModuleIdentifier != (moduleIdentNumber = Long.parseLong(moduleIdentNumberStr, 16))) continue;
                            moduleIndex.put(curSlot, curModule);
                            Map curSubmoduleIndex = (Map)subslotModuleIdentificationNumbers.get(curSlot);
                            for (Map.Entry submoduleEntry : curSubmoduleIndex.entrySet()) {
                                int curSubslot = (Integer)submoduleEntry.getKey();
                                long curSubmoduleIdentNumber = (Long)submoduleEntry.getValue();
                                for (ProfinetVirtualSubmoduleItem curSubmodule : curModule.getVirtualSubmoduleList()) {
                                    long submoduleIdentNumber;
                                    String submoduleIdentNumberStr = curSubmodule.getSubmoduleIdentNumber();
                                    if (submoduleIdentNumberStr.startsWith("0x") || submoduleIdentNumberStr.startsWith("0X")) {
                                        submoduleIdentNumberStr = submoduleIdentNumberStr.substring(2);
                                    }
                                    if (curSubmoduleIdentNumber != (submoduleIdentNumber = Long.parseLong(submoduleIdentNumberStr, 16))) continue;
                                    if (!submoduleIndex.containsKey(curSlot)) {
                                        submoduleIndex.put(curSlot, new HashMap());
                                    }
                                    ((Map)submoduleIndex.get(curSlot)).put(curSubslot, curSubmodule);
                                    if (curSubmodule.getIoData().getInput() != null) {
                                        for (ProfinetIoDataInput profinetIoDataInput : curSubmodule.getIoData().getInput()) {
                                            for (ProfinetDataItem profinetDataItem : profinetIoDataInput.getDataItemList()) {
                                                if (!textMapping.containsKey(profinetDataItem.getTextId())) continue;
                                                profinetDataItem.setTextId((String)textMapping.get(profinetDataItem.getTextId()));
                                            }
                                        }
                                    }
                                    if (curSubmodule.getIoData().getOutput() == null) continue;
                                    for (ProfinetIoDataOutput profinetIoDataOutput : curSubmodule.getIoData().getOutput()) {
                                        for (ProfinetDataItem profinetDataItem : profinetIoDataOutput.getDataItemList()) {
                                            if (!textMapping.containsKey(profinetDataItem.getTextId())) continue;
                                            profinetDataItem.setTextId((String)textMapping.get(profinetDataItem.getTextId()));
                                        }
                                    }
                                }
                            }
                        }
                    }
                    this.profinetDriverContext.setModuleIndex(moduleIndex);
                    this.profinetDriverContext.setSubmoduleIndex(submoduleIndex);
                    context.fireConnected();
                });
            } else {
                this.logger.error("GSD descriptor doesn't contain any device access points");
                context.getChannel().close();
            }
        });
    }

    public void close(ConversationContext<Ethernet_Frame> context) {
        context.getChannel().close();
    }

    public CompletableFuture<PlcBrowseResponse> browse(PlcBrowseRequest browseRequest) {
        HashMap<String, PlcResponseCode> responseCodes = new HashMap<String, PlcResponseCode>();
        HashMap values = new HashMap();
        for (String queryName : browseRequest.getQueryNames()) {
            ArrayList<DefaultPlcBrowseItem> items = new ArrayList<DefaultPlcBrowseItem>();
            for (Map.Entry<Integer, Map<Integer, ProfinetVirtualSubmoduleItem>> slotEntry : this.profinetDriverContext.getSubmoduleIndex().entrySet()) {
                int slot = slotEntry.getKey();
                for (Map.Entry<Integer, ProfinetVirtualSubmoduleItem> subslotEntry : slotEntry.getValue().entrySet()) {
                    String name;
                    ProfinetDataTypeMapper.DataTypeInformation dataTypeInformation;
                    ProfinetDataItem profinetDataItem;
                    int i;
                    int subslot = subslotEntry.getKey();
                    ProfinetVirtualSubmoduleItem subslotModule = subslotEntry.getValue();
                    if (subslotModule.getIoData().getInput() != null) {
                        for (ProfinetIoDataInput profinetIoDataInput : subslotModule.getIoData().getInput()) {
                            i = 0;
                            while (i < profinetIoDataInput.getDataItemList().size()) {
                                profinetDataItem = profinetIoDataInput.getDataItemList().get(i);
                                dataTypeInformation = ProfinetDataTypeMapper.getPlcValueType(profinetDataItem);
                                name = profinetDataItem.getTextId();
                                items.add(new DefaultPlcBrowseItem((PlcTag)new ProfinetTag(slot, subslot, ProfinetTag.Direction.INPUT, i, dataTypeInformation.getPlcValueType(), dataTypeInformation.getNumElements()), name, false, true, true, Collections.emptyMap(), Collections.emptyMap()));
                                ++i;
                            }
                        }
                    }
                    if (subslotModule.getIoData().getOutput() == null) continue;
                    for (ProfinetIoDataOutput profinetIoDataOutput : subslotModule.getIoData().getOutput()) {
                        i = 0;
                        while (i < profinetIoDataOutput.getDataItemList().size()) {
                            profinetDataItem = profinetIoDataOutput.getDataItemList().get(i);
                            dataTypeInformation = ProfinetDataTypeMapper.getPlcValueType(profinetDataItem);
                            name = profinetDataItem.getTextId();
                            items.add(new DefaultPlcBrowseItem((PlcTag)new ProfinetTag(slot, subslot, ProfinetTag.Direction.OUTPUT, i, dataTypeInformation.getPlcValueType(), dataTypeInformation.getNumElements()), name, false, true, true, Collections.emptyMap(), Collections.emptyMap()));
                            ++i;
                        }
                    }
                }
            }
            responseCodes.put(queryName, PlcResponseCode.OK);
            values.put(queryName, items);
        }
        DefaultPlcBrowseResponse response = new DefaultPlcBrowseResponse(browseRequest, responseCodes, values);
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        if (this.profinetDriverContext.getDap() == null) {
            return CompletableFuture.failedFuture((Throwable)new PlcConnectionException("DAP not set"));
        }
        TreeMap slots = new TreeMap();
        for (String tagName : subscriptionRequest.getTagNames()) {
            PlcSubscriptionTag subscriptionTag = subscriptionRequest.getTag(tagName);
            if (!(subscriptionTag.getTag() instanceof ProfinetTag)) continue;
            ProfinetTag profinetTag = (ProfinetTag)subscriptionTag.getTag();
            int slot = profinetTag.getSlot();
            int subSlot = profinetTag.getSubSlot();
            ProfinetTag.Direction direction = profinetTag.getDirection();
            int index = profinetTag.getIndex();
            if (!slots.containsKey(slot)) {
                slots.put(slot, new TreeMap());
            }
            if (!((Map)slots.get(slot)).containsKey(subSlot)) {
                ((Map)slots.get(slot)).put(subSlot, new TreeMap());
            }
            if (!((Map)((Map)slots.get(slot)).get(subSlot)).containsKey((Object)direction)) {
                ((Map)((Map)slots.get(slot)).get(subSlot)).put(direction, new TreeMap());
            }
            ((Map)((Map)((Map)slots.get(slot)).get(subSlot)).get((Object)direction)).put(index, profinetTag);
        }
        int inputFrameOffset = 0;
        int outputFrameOffset = 0;
        ArrayList<PnIoCm_IoDataObject> inputMessageDataObjects = new ArrayList<PnIoCm_IoDataObject>();
        ArrayList<PnIoCm_IoCs> inputMessageCs = new ArrayList<PnIoCm_IoCs>();
        ArrayList<PnIoCm_IoDataObject> outputMessageDataObjects = new ArrayList<PnIoCm_IoDataObject>();
        ArrayList<PnIoCm_IoCs> outputMessageCs = new ArrayList<PnIoCm_IoCs>();
        inputMessageDataObjects.add(new PnIoCm_IoDataObject(0, 1, inputFrameOffset));
        outputMessageCs.add(new PnIoCm_IoCs(0, 1, outputFrameOffset));
        inputMessageDataObjects.add(new PnIoCm_IoDataObject(0, 32768, ++inputFrameOffset));
        outputMessageCs.add(new PnIoCm_IoCs(0, 32768, ++outputFrameOffset));
        inputMessageDataObjects.add(new PnIoCm_IoDataObject(0, 32769, ++inputFrameOffset));
        outputMessageCs.add(new PnIoCm_IoCs(0, 32769, ++outputFrameOffset));
        inputMessageDataObjects.add(new PnIoCm_IoDataObject(0, 32770, ++inputFrameOffset));
        ++inputFrameOffset;
        outputMessageCs.add(new PnIoCm_IoCs(0, 32770, ++outputFrameOffset));
        ++outputFrameOffset;
        ArrayList<PnIoCm_Block_ExpectedSubmoduleReq> expectedSubmodules = new ArrayList<PnIoCm_Block_ExpectedSubmoduleReq>();
        expectedSubmodules.add(new PnIoCm_Block_ExpectedSubmoduleReq(1, 0, Collections.singletonList(new PnIoCm_ExpectedSubmoduleBlockReqApi(0, 16L, 0, Arrays.asList(new PnIoCm_Submodule_NoInputNoOutputData(1, 1L, false, false, false, false), new PnIoCm_Submodule_NoInputNoOutputData(Short.MIN_VALUE, 2L, false, false, false, false), new PnIoCm_Submodule_NoInputNoOutputData(-32767, 3L, false, false, false, false), new PnIoCm_Submodule_NoInputNoOutputData(-32766, 3L, false, false, false, false))))));
        for (Map.Entry slotEntry : slots.entrySet()) {
            int slotNumber = (Integer)slotEntry.getKey();
            Map subslot = (Map)slotEntry.getValue();
            ArrayList<PnIoCm_Submodule> expectedSubmoduleData = new ArrayList<PnIoCm_Submodule>();
            for (Map.Entry subslotEntry : subslot.entrySet()) {
                Object output;
                int iopsLength;
                int subslotNumber = (Integer)subslotEntry.getKey();
                Map direction = (Map)subslotEntry.getValue();
                int iocsLength = this.profinetDriverContext.getSubmoduleIndex().get(slotNumber).get(subslotNumber).getIoData().getIocsLength();
                if (iocsLength == 0) {
                    iocsLength = 1;
                }
                if ((iopsLength = this.profinetDriverContext.getSubmoduleIndex().get(slotNumber).get(subslotNumber).getIoData().getIopsLength()) == 0) {
                    iopsLength = 1;
                }
                PnIoCm_SubmoduleType submoduleType = PnIoCm_SubmoduleType.NO_INPUT_NO_OUTPUT_DATA;
                int inputDataLength = 0;
                int outputDataLength = 0;
                if (direction.containsKey((Object)ProfinetTag.Direction.INPUT)) {
                    submoduleType = PnIoCm_SubmoduleType.INPUT_DATA;
                    Map inputTags = (Map)direction.get((Object)ProfinetTag.Direction.INPUT);
                    for (Map.Entry inputTag : inputTags.entrySet()) {
                        ProfinetTag tag = (ProfinetTag)inputTag.getValue();
                        int dataLength = this.getDataTypeLengthInBytes(tag.getPlcValueType()) * tag.getNumElements();
                        inputDataLength += dataLength;
                        PnIoCm_IoDataObject input = new PnIoCm_IoDataObject(slotNumber, subslotNumber, inputFrameOffset);
                        inputMessageDataObjects.add(input);
                        output = new PnIoCm_IoCs(slotNumber, subslotNumber, inputFrameOffset += dataLength + iocsLength);
                        inputMessageCs.add((PnIoCm_IoCs)output);
                    }
                }
                if (direction.containsKey((Object)ProfinetTag.Direction.OUTPUT)) {
                    if (submoduleType == PnIoCm_SubmoduleType.NO_INPUT_NO_OUTPUT_DATA) {
                        submoduleType = PnIoCm_SubmoduleType.OUTPUT_DATA;
                    } else if (submoduleType == PnIoCm_SubmoduleType.INPUT_DATA) {
                        submoduleType = PnIoCm_SubmoduleType.INPUT_AND_OUTPUT_DATA;
                    }
                    Map outputTags = (Map)direction.get((Object)ProfinetTag.Direction.OUTPUT);
                    for (Map.Entry outputTag : outputTags.entrySet()) {
                        PnIoCm_IoCs input = new PnIoCm_IoCs(slotNumber, subslotNumber, outputFrameOffset);
                        outputMessageCs.add(input);
                        outputFrameOffset += iocsLength;
                        ProfinetTag tag = (ProfinetTag)outputTag.getValue();
                        int dataLength = this.getDataTypeLengthInBytes(tag.getPlcValueType()) * tag.getNumElements();
                        outputDataLength += dataLength;
                        output = new PnIoCm_IoDataObject(slotNumber, subslotNumber, outputFrameOffset += dataLength);
                        outputMessageDataObjects.add((PnIoCm_IoDataObject)output);
                        inputFrameOffset += iopsLength;
                        outputFrameOffset += dataLength + iopsLength;
                    }
                }
                switch (submoduleType) {
                    case NO_INPUT_NO_OUTPUT_DATA: {
                        expectedSubmoduleData.add(new PnIoCm_Submodule_NoInputNoOutputData((short)subslotNumber, 16L, false, false, false, false));
                        break;
                    }
                    case INPUT_DATA: {
                        expectedSubmoduleData.add(new PnIoCm_Submodule_InputData((short)subslotNumber, 16L, false, false, false, false, inputDataLength));
                        break;
                    }
                    case OUTPUT_DATA: {
                        expectedSubmoduleData.add(new PnIoCm_Submodule_OutputData((short)subslotNumber, 16L, false, false, false, false, outputDataLength));
                        break;
                    }
                    case INPUT_AND_OUTPUT_DATA: {
                        expectedSubmoduleData.add(new PnIoCm_Submodule_InputAndOutputData((short)subslotNumber, 16L, false, false, false, false, inputDataLength, outputDataLength));
                    }
                }
            }
            expectedSubmodules.add(new PnIoCm_Block_ExpectedSubmoduleReq(1, 0, Collections.singletonList(new PnIoCm_ExpectedSubmoduleBlockReqApi(slotNumber, 32L, 0, expectedSubmoduleData))));
        }
        RawSocketChannel rawSocketChannel = (RawSocketChannel)this.context.getChannel();
        MacAddress remoteMacAddress = new MacAddress(rawSocketChannel.getRemoteMacAddress().getAddress());
        InetSocketAddress remoteAddress = (InetSocketAddress)rawSocketChannel.getRemoteAddress();
        MacAddress localMacAddress = new MacAddress(rawSocketChannel.getLocalMacAddress().getAddress());
        InetSocketAddress localAddress = (InetSocketAddress)rawSocketChannel.getLocalAddress();
        ArrayList<PnIoCm_Block> blocks = new ArrayList<PnIoCm_Block>();
        blocks.add(new PnIoCm_Block_ArReq(1, 0, PnIoCm_ArType.IO_CONTROLLER, this.profinetDriverContext.getApplicationRelationUuid(), this.profinetDriverContext.getSessionKey(), localMacAddress, this.profinetDriverContext.getCmInitiatorObjectUuid(), false, this.profinetDriverContext.isAdvancedStartupMode(), false, false, PnIoCm_CompanionArType.SINGLE_AR, false, true, false, PnIoCm_State.ACTIVE, 600, 34962, "plc4x"));
        blocks.add(new PnIoCm_Block_AlarmCrReq(1, 0, PnIoCm_AlarmCrType.ALARM_CR, 34962, false, false, 1, 3, 0, 200, 49152, 40960));
        if (!inputMessageDataObjects.isEmpty() || !inputMessageCs.isEmpty()) {
            blocks.add(new PnIoCm_Block_IoCrReq(1, 0, PnIoCm_IoCrType.INPUT_CR, 1, 34962, false, false, false, false, PnIoCm_RtClass.RT_CLASS_2, 40, 0x8000 | this.profinetDriverContext.getAndIncrementIdentification(), this.profinetDriverContext.getSendClockFactor(), this.profinetDriverContext.getReductionRatio(), 1, 0, 0xFFFFFFFFL, this.profinetDriverContext.getWatchdogFactor(), this.profinetDriverContext.getDataHoldFactor(), 49152, ProfinetDriverContext.DEFAULT_EMPTY_MAC_ADDRESS, Collections.singletonList(new PnIoCm_IoCrBlockReqApi(inputMessageDataObjects, inputMessageCs))));
        }
        if (!outputMessageDataObjects.isEmpty() || !outputMessageCs.isEmpty()) {
            blocks.add(new PnIoCm_Block_IoCrReq(1, 0, PnIoCm_IoCrType.OUTPUT_CR, 2, 34962, false, false, false, false, PnIoCm_RtClass.RT_CLASS_2, 40, 0x8000 | this.profinetDriverContext.getAndIncrementIdentification(), this.profinetDriverContext.getSendClockFactor(), this.profinetDriverContext.getReductionRatio(), 1, 0, 0xFFFFFFFFL, this.profinetDriverContext.getWatchdogFactor(), this.profinetDriverContext.getDataHoldFactor(), 49152, ProfinetDriverContext.DEFAULT_EMPTY_MAC_ADDRESS, Collections.singletonList(new PnIoCm_IoCrBlockReqApi(outputMessageDataObjects, outputMessageCs))));
        }
        blocks.addAll(expectedSubmodules);
        PnIoCm_Packet_Req request = new PnIoCm_Packet_Req(16696L, 16696L, 0L, blocks);
        DceRpc_Packet packet = new DceRpc_Packet(DceRpc_PacketType.REQUEST, true, false, false, IntegerEncoding.BIG_ENDIAN, CharacterEncoding.ASCII, FloatingPointEncoding.IEEE, new DceRpc_ObjectUuid(0, 1, this.profinetDriverContext.getDeviceId(), this.profinetDriverContext.getVendorId()), new DceRpc_InterfaceUuid_DeviceInterface(), this.profinetDriverContext.getActivityUuid(), 0L, 1L, DceRpc_Operation.CONNECT, 0, request);
        SecureRandom rand = new SecureRandom();
        Ethernet_FramePayload_IPv4 udpFrame = new Ethernet_FramePayload_IPv4(rand.nextInt(65536), true, false, 64, new IpAddress(localAddress.getAddress().getAddress()), new IpAddress(remoteAddress.getAddress().getAddress()), this.profinetDriverContext.getLocalPort(), this.profinetDriverContext.getRemotePortImplicitCommunication(), packet);
        Ethernet_Frame requestEthernetFrame = new Ethernet_Frame(remoteMacAddress, localMacAddress, udpFrame);
        CompletableFuture<PlcSubscriptionResponse> future = new CompletableFuture<PlcSubscriptionResponse>();
        this.context.sendRequest((Object)requestEthernetFrame).name("Expect Subscription response").expectResponse(Ethernet_Frame.class, Duration.ofMillis(1000L)).onTimeout(future::completeExceptionally).onError((responseEthernetFrame, throwable) -> {
            boolean bl = future.completeExceptionally((Throwable)throwable);
        }).unwrap(Ethernet_Frame::getPayload).only(Ethernet_FramePayload_IPv4.class).unwrap(Ethernet_FramePayload_IPv4::getPayload).handle(dceRpcPacket -> {
            if (dceRpcPacket.getPacketType() != DceRpc_PacketType.RESPONSE) {
                future.completeExceptionally((Throwable)new PlcException("Expected a response"));
                return;
            }
            PnIoCm_Packet_Res payload = (PnIoCm_Packet_Res)dceRpcPacket.getPayload();
            this.context.expectRequest(Ethernet_Frame.class, Duration.ofMillis(500000L)).name("Expect ApplicationReady request").onTimeout(future::completeExceptionally).check(ethernetFrame -> ethernetFrame.getPayload() instanceof Ethernet_FramePayload_IPv4).unwrap(ethernetFrame -> (Ethernet_FramePayload_IPv4)ethernetFrame.getPayload()).check(payloadIPv4 -> payloadIPv4.getPayload().getPayload() instanceof PnIoCm_Packet_Req).check(payloadIPv4 -> ((PnIoCm_Packet_Req)payloadIPv4.getPayload().getPayload()).getBlocks().size() == 1 && ((PnIoCm_Packet_Req)payloadIPv4.getPayload().getPayload()).getBlocks().get(0) instanceof PnIoCm_Control_Request_ApplicationReady).handle(payloadIPv4 -> {
                DceRpc_Packet dceRpc_packet = payloadIPv4.getPayload();
                PnIoCm_Control_Request_ApplicationReady pnIoCmBlock = (PnIoCm_Control_Request_ApplicationReady)((PnIoCm_Packet_Req)dceRpc_packet.getPayload()).getBlocks().get(0);
                Uuid arUuid = pnIoCmBlock.getArUuid();
                int sessionKey = pnIoCmBlock.getSessionKey();
                RawSocketChannel pnChannel = (RawSocketChannel)this.context.getChannel();
                PnDcpPacketFactory.sendApplicationReadyResponse((ConversationContext<Ethernet_Frame>)this.context, pnChannel, this.profinetDriverContext, payloadIPv4.getSourcePort(), dceRpc_packet.getActivityUuid(), arUuid, sessionKey);
                this.connected = true;
            });
            CompletableFuture<PnIoCm_Control_Response_ParameterEnd> parameterEndFuture = PnDcpPacketFactory.sendParameterEndRequest((ConversationContext<Ethernet_Frame>)this.context, rawSocketChannel, this.profinetDriverContext);
            parameterEndFuture.whenComplete((parameterEnd, throwable) -> {});
        });
        return future;
    }

    protected void decode(ConversationContext<Ethernet_Frame> context, Ethernet_Frame msg) throws Exception {
        RawSocketChannel pnChannel = (RawSocketChannel)context.getChannel();
        if (msg.getPayload() instanceof Ethernet_FramePayload_PnDcp) {
            Ethernet_FramePayload_PnDcp dcpPacket = (Ethernet_FramePayload_PnDcp)msg.getPayload();
            if (dcpPacket.getPdu() instanceof PnDcp_Pdu_RealTimeCyclic) {
                PnDcp_Pdu_RealTimeCyclic pnDcp_Pdu_RealTimeCyclic = (PnDcp_Pdu_RealTimeCyclic)dcpPacket.getPdu();
            } else {
                System.out.println(dcpPacket);
            }
        } else if (msg.getPayload() instanceof Ethernet_FramePayload_IPv4) {
            Ethernet_FramePayload_IPv4 payloadIPv4 = (Ethernet_FramePayload_IPv4)msg.getPayload();
            if (payloadIPv4.getPayload().getPayload() instanceof PnIoCm_Packet_Ping) {
                DceRpc_Packet pingPacket = payloadIPv4.getPayload();
                PnDcpPacketFactory.sendPingResponse(context, pnChannel, this.profinetDriverContext, payloadIPv4);
            } else if (payloadIPv4.getPayload().getPayload() instanceof PnIoCm_Packet_ConnectionlessCancel) {
                context.getChannel().close();
            } else {
                System.out.println(msg);
            }
        }
    }

    protected void extractBlockInfo(List<PnDcp_Block> blocks) {
        PnDcp_Block block2;
        HashMap<String, PnDcp_Block> blockMap = new HashMap<String, PnDcp_Block>();
        for (PnDcp_Block block2 : blocks) {
            String blockName = String.valueOf(block2.getOption().name()) + "-" + block2.getSuboption().toString();
            blockMap.put(blockName, block2);
        }
        if (blockMap.containsKey("DEVICE_PROPERTIES_OPTION-1")) {
            block2 = (PnDcp_Block_DevicePropertiesDeviceVendor)blockMap.get("DEVICE_PROPERTIES_OPTION-1");
            this.profinetDriverContext.setDeviceType(new String(((PnDcp_Block_DevicePropertiesDeviceVendor)block2).getDeviceVendorValue()));
        }
        if (blockMap.containsKey("DEVICE_PROPERTIES_OPTION-2")) {
            block2 = (PnDcp_Block_DevicePropertiesNameOfStation)blockMap.get("DEVICE_PROPERTIES_OPTION-2");
            this.profinetDriverContext.setDeviceName(new String(((PnDcp_Block_DevicePropertiesNameOfStation)block2).getNameOfStation()));
        }
        if (blockMap.containsKey("DEVICE_PROPERTIES_OPTION-4")) {
            block2 = (PnDcp_Block_DevicePropertiesDeviceRole)blockMap.get("DEVICE_PROPERTIES_OPTION-4");
            ArrayList<String> roles = new ArrayList<String>();
            if (((PnDcp_Block_DevicePropertiesDeviceRole)block2).getPnioSupervisor()) {
                roles.add("SUPERVISOR");
            }
            if (((PnDcp_Block_DevicePropertiesDeviceRole)block2).getPnioMultidevive()) {
                roles.add("MULTIDEVICE");
            }
            if (((PnDcp_Block_DevicePropertiesDeviceRole)block2).getPnioController()) {
                roles.add("CONTROLLER");
            }
            if (((PnDcp_Block_DevicePropertiesDeviceRole)block2).getPnioDevice()) {
                roles.add("DEVICE");
            }
            this.profinetDriverContext.setRoles(roles);
        }
        if (blockMap.containsKey("DEVICE_PROPERTIES_OPTION-3")) {
            block2 = (PnDcp_Block_DevicePropertiesDeviceId)blockMap.get("DEVICE_PROPERTIES_OPTION-3");
            this.profinetDriverContext.setVendorId(((PnDcp_Block_DevicePropertiesDeviceId)block2).getVendorId());
            this.profinetDriverContext.setDeviceId(((PnDcp_Block_DevicePropertiesDeviceId)block2).getDeviceId());
        }
    }

    protected int getDataTypeLengthInBytes(PlcValueType dataType) {
        switch (dataType) {
            case NULL: {
                return 0;
            }
            case BOOL: 
            case BYTE: 
            case USINT: 
            case SINT: 
            case CHAR: {
                return 1;
            }
            case WORD: 
            case UINT: 
            case INT: 
            case WCHAR: {
                return 2;
            }
            case DWORD: 
            case UDINT: 
            case DINT: 
            case REAL: {
                return 4;
            }
            case LWORD: 
            case ULINT: 
            case LINT: 
            case LREAL: {
                return 8;
            }
            case STRING: 
            case WSTRING: 
            case TIME: 
            case LTIME: 
            case DATE: 
            case LDATE: 
            case TIME_OF_DAY: 
            case LTIME_OF_DAY: 
            case DATE_AND_TIME: 
            case LDATE_AND_TIME: 
            case Struct: 
            case List: 
            case RAW_BYTE_ARRAY: {
                throw new PlcRuntimeException("Length undefined for type " + dataType.name());
            }
        }
        throw new PlcRuntimeException("Length undefined");
    }
}

