/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum FloatingPointEncoding {
    IEEE(0),
    VAX(1),
    CRAY(2),
    IBM(3);

    private static final Map<Short, FloatingPointEncoding> map;
    private final short value;

    static {
        map = new HashMap<Short, FloatingPointEncoding>();
        FloatingPointEncoding[] floatingPointEncodingArray = FloatingPointEncoding.values();
        int n = floatingPointEncodingArray.length;
        int n2 = 0;
        while (n2 < n) {
            FloatingPointEncoding value = floatingPointEncodingArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private FloatingPointEncoding(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static FloatingPointEncoding enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

