/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum IntegerEncoding {
    BIG_ENDIAN(0),
    LITTLE_ENDIAN(1);

    private static final Map<Byte, IntegerEncoding> map;
    private final byte value;

    static {
        map = new HashMap<Byte, IntegerEncoding>();
        IntegerEncoding[] integerEncodingArray = IntegerEncoding.values();
        int n = integerEncodingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IntegerEncoding value = integerEncodingArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private IntegerEncoding(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static IntegerEncoding enumForValue(byte value) {
        return map.get(value);
    }

    public static Boolean isDefined(byte value) {
        return map.containsKey(value);
    }
}

