/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.profinet.readwrite.EndOfLldp;
import org.apache.plc4x.java.profinet.readwrite.TlvChassisId;
import org.apache.plc4x.java.profinet.readwrite.TlvManagementAddress;
import org.apache.plc4x.java.profinet.readwrite.TlvOrganizationSpecific;
import org.apache.plc4x.java.profinet.readwrite.TlvPortDescription;
import org.apache.plc4x.java.profinet.readwrite.TlvPortId;
import org.apache.plc4x.java.profinet.readwrite.TlvSystemCapabilities;
import org.apache.plc4x.java.profinet.readwrite.TlvSystemDescription;
import org.apache.plc4x.java.profinet.readwrite.TlvSystemName;
import org.apache.plc4x.java.profinet.readwrite.TlvTimeToLive;
import org.apache.plc4x.java.profinet.readwrite.TlvType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class LldpUnit
implements Message {
    protected final short tlvIdLength;

    public abstract TlvType getTlvId();

    public LldpUnit(short tlvIdLength) {
        this.tlvIdLength = tlvIdLength;
    }

    public short getTlvIdLength() {
        return this.tlvIdLength;
    }

    protected abstract void serializeLldpUnitChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("LldpUnit", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorEnumField((String)"tlvId", (String)"TlvType", (Object)((Object)this.getTlvId()), (DataWriter)new DataWriterEnumDefault(TlvType::getValue, Enum::name, DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"tlvIdLength", (Object)this.tlvIdLength, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)9), (WithWriterArgs[])new WithWriterArgs[0]);
        this.serializeLldpUnitChild(writeBuffer);
        writeBuffer.popContext("LldpUnit", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        LldpUnit _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 7;
        return lengthInBits += 9;
    }

    public static LldpUnit staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return LldpUnit.staticParse(readBuffer);
    }

    public static LldpUnit staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("LldpUnit", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        TlvType tlvId = (TlvType)((Object)FieldReaderFactory.readDiscriminatorEnumField((String)"tlvId", (String)"TlvType", (DataReader)new DataReaderEnumDefault(TlvType::enumForValue, DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7)), (WithReaderArgs[])new WithReaderArgs[0]));
        short tlvIdLength = (Short)FieldReaderFactory.readSimpleField((String)"tlvIdLength", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)9), (WithReaderArgs[])new WithReaderArgs[0]);
        LldpUnitBuilder builder = null;
        if (EvaluationHelper.equals((Object)((Object)tlvId), (Object)((Object)TlvType.END_OF_LLDP))) {
            builder = EndOfLldp.staticParseLldpUnitBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)((Object)tlvId), (Object)((Object)TlvType.CHASSIS_ID))) {
            builder = TlvChassisId.staticParseLldpUnitBuilder(readBuffer, tlvIdLength);
        } else if (EvaluationHelper.equals((Object)((Object)tlvId), (Object)((Object)TlvType.PORT_ID))) {
            builder = TlvPortId.staticParseLldpUnitBuilder(readBuffer, tlvIdLength);
        } else if (EvaluationHelper.equals((Object)((Object)tlvId), (Object)((Object)TlvType.TIME_TO_LIVE))) {
            builder = TlvTimeToLive.staticParseLldpUnitBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)((Object)tlvId), (Object)((Object)TlvType.PORT_DESCRIPTION))) {
            builder = TlvPortDescription.staticParseLldpUnitBuilder(readBuffer, tlvIdLength);
        } else if (EvaluationHelper.equals((Object)((Object)tlvId), (Object)((Object)TlvType.SYSTEM_NAME))) {
            builder = TlvSystemName.staticParseLldpUnitBuilder(readBuffer, tlvIdLength);
        } else if (EvaluationHelper.equals((Object)((Object)tlvId), (Object)((Object)TlvType.SYSTEM_DESCRIPTION))) {
            builder = TlvSystemDescription.staticParseLldpUnitBuilder(readBuffer, tlvIdLength);
        } else if (EvaluationHelper.equals((Object)((Object)tlvId), (Object)((Object)TlvType.SYSTEM_CAPABILITIES))) {
            builder = TlvSystemCapabilities.staticParseLldpUnitBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)((Object)tlvId), (Object)((Object)TlvType.MANAGEMENT_ADDRESS))) {
            builder = TlvManagementAddress.staticParseLldpUnitBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)((Object)tlvId), (Object)((Object)TlvType.ORGANIZATION_SPECIFIC))) {
            builder = TlvOrganizationSpecific.staticParseLldpUnitBuilder(readBuffer);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [tlvId=" + (Object)((Object)tlvId) + "]");
        }
        readBuffer.closeContext("LldpUnit", new WithReaderArgs[0]);
        LldpUnit _lldpUnit = builder.build(tlvIdLength);
        return _lldpUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LldpUnit)) {
            return false;
        }
        LldpUnit that = (LldpUnit)o;
        return this.getTlvIdLength() == that.getTlvIdLength();
    }

    public int hashCode() {
        return Objects.hash(this.getTlvIdLength());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface LldpUnitBuilder {
        public LldpUnit build(short var1);
    }
}

