/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ProfinetDataType {
    BOOL(1, 1, "BOOLEAN"),
    BYTE(2, 1, "BYTE"),
    WORD(3, 2, "WORD"),
    DWORD(4, 4, "DWORD"),
    LWORD(5, 8, "LWORD"),
    SINT(6, 1, "SIGNED8"),
    INT(7, 2, "SIGNED16"),
    DINT(8, 4, "SIGNED32"),
    LINT(9, 8, "SIGNED64"),
    USINT(10, 1, "UNSIGNED8"),
    UINT(11, 2, "UNSIGNED16"),
    UDINT(12, 4, "UNSIGNED32"),
    ULINT(13, 8, "UNSIGNED64"),
    REAL(14, 4, "FLOAT32"),
    LREAL(15, 8, "FLOAT64"),
    TIME(16, 8, "TIME"),
    LTIME(17, 8, "LTIME"),
    DATE(18, 8, "DATE"),
    LDATE(19, 8, "LDATE"),
    TIME_OF_DAY(20, 8, "TIME_OF_DAY"),
    LTIME_OF_DAY(21, 8, "LTIME_OF_DAY"),
    DATE_AND_TIME(22, 8, "DATE_AND_TIME"),
    LDATE_AND_TIME(23, 8, "LDATE_AND_TIME"),
    CHAR(24, 1, "CHAR"),
    WCHAR(25, 2, "WCHAR"),
    UNICODESTRING8(26, 1, "UNICODESTRING8"),
    WSTRING(27, 2, "WSTRING"),
    VISIBLESTRING(28, 1, "VISIBLESTRING"),
    F_MESSAGETRAILER4BYTE(29, 4, "F_MESSAGETRAILER4BYTE"),
    TIMESTAMP(30, 12, "TIMESTAMP"),
    TIMESTAMPDIFFERENCE(31, 12, "TIMESTAMPDIFFERENCE"),
    TIMESTAMPDIFFERENCESHORT(32, 8, "TIMESTAMPDIFFERENCESHORT"),
    OCTETSTRING(33, 1, "OCTETSTRING");

    private static final Map<Short, ProfinetDataType> map;
    private final short value;
    private final short dataTypeSize;
    private final String conversion;

    static {
        map = new HashMap<Short, ProfinetDataType>();
        ProfinetDataType[] profinetDataTypeArray = ProfinetDataType.values();
        int n = profinetDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfinetDataType value = profinetDataTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private ProfinetDataType(short value, short dataTypeSize, String conversion) {
        this.value = value;
        this.dataTypeSize = dataTypeSize;
        this.conversion = conversion;
    }

    public short getValue() {
        return this.value;
    }

    public short getDataTypeSize() {
        return this.dataTypeSize;
    }

    public static ProfinetDataType firstEnumForFieldDataTypeSize(short fieldValue) {
        ProfinetDataType[] profinetDataTypeArray = ProfinetDataType.values();
        int n = profinetDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfinetDataType _val = profinetDataTypeArray[n2];
            if (_val.getDataTypeSize() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<ProfinetDataType> enumsForFieldDataTypeSize(short fieldValue) {
        ArrayList<ProfinetDataType> _values = new ArrayList<ProfinetDataType>();
        ProfinetDataType[] profinetDataTypeArray = ProfinetDataType.values();
        int n = profinetDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfinetDataType _val = profinetDataTypeArray[n2];
            if (_val.getDataTypeSize() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public String getConversion() {
        return this.conversion;
    }

    public static ProfinetDataType firstEnumForFieldConversion(String fieldValue) {
        ProfinetDataType[] profinetDataTypeArray = ProfinetDataType.values();
        int n = profinetDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfinetDataType _val = profinetDataTypeArray[n2];
            if (_val.getConversion().equals(fieldValue)) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<ProfinetDataType> enumsForFieldConversion(String fieldValue) {
        ArrayList<ProfinetDataType> _values = new ArrayList<ProfinetDataType>();
        ProfinetDataType[] profinetDataTypeArray = ProfinetDataType.values();
        int n = profinetDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfinetDataType _val = profinetDataTypeArray[n2];
            if (_val.getConversion().equals(fieldValue)) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static ProfinetDataType enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

