/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.profinet.readwrite.IpAddress;
import org.apache.plc4x.java.profinet.readwrite.LldpUnit;
import org.apache.plc4x.java.profinet.readwrite.ManagementAddressSubType;
import org.apache.plc4x.java.profinet.readwrite.TlvType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class TlvManagementAddress
extends LldpUnit
implements Message {
    protected final ManagementAddressSubType addressSubType;
    protected final IpAddress ipAddress;
    protected final short interfaceSubType;
    protected final long interfaceNumber;
    protected final short oidStringLength;

    @Override
    public TlvType getTlvId() {
        return TlvType.MANAGEMENT_ADDRESS;
    }

    public TlvManagementAddress(short tlvIdLength, ManagementAddressSubType addressSubType, IpAddress ipAddress, short interfaceSubType, long interfaceNumber, short oidStringLength) {
        super(tlvIdLength);
        this.addressSubType = addressSubType;
        this.ipAddress = ipAddress;
        this.interfaceSubType = interfaceSubType;
        this.interfaceNumber = interfaceNumber;
        this.oidStringLength = oidStringLength;
    }

    public ManagementAddressSubType getAddressSubType() {
        return this.addressSubType;
    }

    public IpAddress getIpAddress() {
        return this.ipAddress;
    }

    public short getInterfaceSubType() {
        return this.interfaceSubType;
    }

    public long getInterfaceNumber() {
        return this.interfaceNumber;
    }

    public short getOidStringLength() {
        return this.oidStringLength;
    }

    @Override
    protected void serializeLldpUnitChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("TlvManagementAddress", new WithWriterArgs[0]);
        short addressStringLength = 5;
        FieldWriterFactory.writeImplicitField((String)"addressStringLength", (Object)addressStringLength, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"addressSubType", (String)"ManagementAddressSubType", (Object)((Object)this.addressSubType), (DataWriter)new DataWriterEnumDefault(ManagementAddressSubType::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"ipAddress", (Object)this.ipAddress, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"interfaceSubType", (Object)this.interfaceSubType, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"interfaceNumber", (Object)this.interfaceNumber, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"oidStringLength", (Object)this.oidStringLength, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("TlvManagementAddress", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        TlvManagementAddress _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += this.ipAddress.getLengthInBits();
        lengthInBits += 8;
        lengthInBits += 32;
        return lengthInBits += 8;
    }

    public static LldpUnit.LldpUnitBuilder staticParseLldpUnitBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("TlvManagementAddress", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short addressStringLength = (Short)FieldReaderFactory.readImplicitField((String)"addressStringLength", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        ManagementAddressSubType addressSubType = (ManagementAddressSubType)((Object)FieldReaderFactory.readEnumField((String)"addressSubType", (String)"ManagementAddressSubType", (DataReader)new DataReaderEnumDefault(ManagementAddressSubType::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[0]));
        IpAddress ipAddress = (IpAddress)FieldReaderFactory.readSimpleField((String)"ipAddress", (DataReader)new DataReaderComplexDefault(() -> IpAddress.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short interfaceSubType = (Short)FieldReaderFactory.readSimpleField((String)"interfaceSubType", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        long interfaceNumber = (Long)FieldReaderFactory.readSimpleField((String)"interfaceNumber", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        short oidStringLength = (Short)FieldReaderFactory.readSimpleField((String)"oidStringLength", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("TlvManagementAddress", new WithReaderArgs[0]);
        return new TlvManagementAddressBuilderImpl(addressSubType, ipAddress, interfaceSubType, interfaceNumber, oidStringLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TlvManagementAddress)) {
            return false;
        }
        TlvManagementAddress that = (TlvManagementAddress)o;
        return this.getAddressSubType() == that.getAddressSubType() && this.getIpAddress() == that.getIpAddress() && this.getInterfaceSubType() == that.getInterfaceSubType() && this.getInterfaceNumber() == that.getInterfaceNumber() && this.getOidStringLength() == that.getOidStringLength() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getAddressSubType(), this.getIpAddress(), this.getInterfaceSubType(), this.getInterfaceNumber(), this.getOidStringLength()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class TlvManagementAddressBuilderImpl
    implements LldpUnit.LldpUnitBuilder {
        private final ManagementAddressSubType addressSubType;
        private final IpAddress ipAddress;
        private final short interfaceSubType;
        private final long interfaceNumber;
        private final short oidStringLength;

        public TlvManagementAddressBuilderImpl(ManagementAddressSubType addressSubType, IpAddress ipAddress, short interfaceSubType, long interfaceNumber, short oidStringLength) {
            this.addressSubType = addressSubType;
            this.ipAddress = ipAddress;
            this.interfaceSubType = interfaceSubType;
            this.interfaceNumber = interfaceNumber;
            this.oidStringLength = oidStringLength;
        }

        @Override
        public TlvManagementAddress build(short tlvIdLength) {
            TlvManagementAddress tlvManagementAddress = new TlvManagementAddress(tlvIdLength, this.addressSubType, this.ipAddress, this.interfaceSubType, this.interfaceNumber, this.oidStringLength);
            return tlvManagementAddress;
        }
    }
}

