/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.profinet.readwrite.LldpUnit;
import org.apache.plc4x.java.profinet.readwrite.TlvType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class TlvSystemDescription
extends LldpUnit
implements Message {
    protected final String chassisId;

    @Override
    public TlvType getTlvId() {
        return TlvType.SYSTEM_DESCRIPTION;
    }

    public TlvSystemDescription(short tlvIdLength, String chassisId) {
        super(tlvIdLength);
        this.chassisId = chassisId;
    }

    public String getChassisId() {
        return this.chassisId;
    }

    @Override
    protected void serializeLldpUnitChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("TlvSystemDescription", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"chassisId", (Object)this.chassisId, (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)(this.tlvIdLength * 8)), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("TlvSystemDescription", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        TlvSystemDescription _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.tlvIdLength * 8;
    }

    public static LldpUnit.LldpUnitBuilder staticParseLldpUnitBuilder(ReadBuffer readBuffer, Short tlvIdLength) throws ParseException {
        readBuffer.pullContext("TlvSystemDescription", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        String chassisId = (String)FieldReaderFactory.readSimpleField((String)"chassisId", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)(tlvIdLength * 8)), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("TlvSystemDescription", new WithReaderArgs[0]);
        return new TlvSystemDescriptionBuilderImpl(chassisId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TlvSystemDescription)) {
            return false;
        }
        TlvSystemDescription that = (TlvSystemDescription)o;
        return this.getChassisId() == that.getChassisId() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getChassisId());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class TlvSystemDescriptionBuilderImpl
    implements LldpUnit.LldpUnitBuilder {
        private final String chassisId;

        public TlvSystemDescriptionBuilderImpl(String chassisId) {
            this.chassisId = chassisId;
        }

        @Override
        public TlvSystemDescription build(short tlvIdLength) {
            TlvSystemDescription tlvSystemDescription = new TlvSystemDescription(tlvIdLength, this.chassisId);
            return tlvSystemDescription;
        }
    }
}

