/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum TlvType {
    END_OF_LLDP(0),
    CHASSIS_ID(1),
    PORT_ID(2),
    TIME_TO_LIVE(3),
    PORT_DESCRIPTION(4),
    SYSTEM_NAME(5),
    SYSTEM_DESCRIPTION(6),
    SYSTEM_CAPABILITIES(7),
    MANAGEMENT_ADDRESS(8),
    ORGANIZATION_SPECIFIC(127);

    private static final Map<Byte, TlvType> map;
    private final byte value;

    static {
        map = new HashMap<Byte, TlvType>();
        TlvType[] tlvTypeArray = TlvType.values();
        int n = tlvTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TlvType value = tlvTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private TlvType(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static TlvType enumForValue(byte value) {
        return map.get(value);
    }

    public static Boolean isDefined(byte value) {
        return map.containsKey(value);
    }
}

