/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite.utils;

import java.util.Arrays;
import java.util.List;
import org.apache.plc4x.java.profinet.readwrite.DceRpc_Packet;
import org.apache.plc4x.java.profinet.readwrite.IpAddress;
import org.apache.plc4x.java.profinet.readwrite.LldpUnit;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_FrameId;
import org.apache.plc4x.java.profinet.readwrite.PnIo_CyclicServiceDataUnit;
import org.apache.plc4x.java.profinet.readwrite.Uuid;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;

public class StaticHelper {
    private static final byte[] nullUuid = new byte[16];

    public static int arrayLength(byte[] arr) {
        return arr.length;
    }

    public static short calculateIPv4Checksum(int totalLength, int identification, int timeToLive, IpAddress sourceAddress, IpAddress destinationAddress) {
        int[] words = new int[10];
        words[0] = 17664;
        words[1] = totalLength;
        words[2] = identification;
        words[3] = 16384;
        words[4] = (timeToLive & 0xFF) << 8 | 0x11;
        words[5] = 0;
        byte[] data = sourceAddress.getData();
        words[6] = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        words[7] = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        data = destinationAddress.getData();
        words[8] = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        words[9] = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        int cur = 0;
        int i = 0;
        while (i < 10) {
            cur += words[i];
            while (cur > 65535) {
                cur &= 0xFFFF;
                ++cur;
            }
            ++i;
        }
        return ~((short)cur);
    }

    public static short calculateUdpChecksum(IpAddress sourceAddress, IpAddress destinationAddress, int sourcePort, int destPort, int packetLength, DceRpc_Packet payload) {
        int[] words = new int[10];
        byte[] data = sourceAddress.getData();
        words[0] = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        words[1] = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        data = destinationAddress.getData();
        words[2] = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        words[3] = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        words[4] = 17;
        words[5] = packetLength;
        words[6] = sourcePort;
        words[7] = destPort;
        words[8] = packetLength;
        words[9] = 0;
        int cur = 0;
        int i = 0;
        while (i < 10) {
            cur += words[i];
            while (cur > 65535) {
                cur &= 0xFFFF;
                ++cur;
            }
            ++i;
        }
        boolean evenSize = payload.getLengthInBytes() % 2 == 0;
        WriteBufferByteBased buffer = evenSize ? new WriteBufferByteBased(payload.getLengthInBytes(), ByteOrder.BIG_ENDIAN) : new WriteBufferByteBased(payload.getLengthInBytes() + 1, ByteOrder.BIG_ENDIAN);
        try {
            payload.serialize((WriteBuffer)buffer);
            if (!evenSize) {
                buffer.writeByte("Padding", (byte)0, new WithWriterArgs[0]);
            }
            byte[] byteBuffer = buffer.getBytes();
            int i2 = 0;
            while (i2 < byteBuffer.length - 1) {
                int w = (byteBuffer[i2] & 0xFF) << 8 | byteBuffer[i2 + 1] & 0xFF;
                cur += w;
                while (cur > 65535) {
                    cur &= 0xFFFF;
                    ++cur;
                }
                i2 += 2;
            }
        }
        catch (SerializationException e) {
            return 0;
        }
        return ~((short)cur);
    }

    public static void main(String[] args) {
        System.out.println(StaticHelper.calculateIPv4Checksum(532, 17631, 64, new IpAddress(new byte[]{-64, -88, 24, -56}), new IpAddress(new byte[]{-64, -88, 24, 31})));
        System.out.println(StaticHelper.calculateIPv4Checksum(198, 72, 30, new IpAddress(new byte[]{-64, -88, 24, 31}), new IpAddress(new byte[]{-64, -88, 24, -56})));
    }

    public static PnDcp_FrameId getFrameId(int frameIdValue) {
        if (frameIdValue == 32) {
            return PnDcp_FrameId.PTCP_RTSyncPDUWithFollowUp;
        }
        if (frameIdValue == 128) {
            return PnDcp_FrameId.PTCP_RTSyncPDU;
        }
        if (frameIdValue >= 256 && frameIdValue <= 4095) {
            return PnDcp_FrameId.RT_CLASS_3;
        }
        if (frameIdValue >= 8000 && frameIdValue <= 49151) {
            return PnDcp_FrameId.RT_CLASS_1;
        }
        if (frameIdValue >= 49152 && frameIdValue <= 64511) {
            return PnDcp_FrameId.RT_CLASS_UDP;
        }
        if (frameIdValue == 64513) {
            return PnDcp_FrameId.Alarm_High;
        }
        if (frameIdValue == 65025) {
            return PnDcp_FrameId.Alarm_Low;
        }
        if (frameIdValue == 65276) {
            return PnDcp_FrameId.DCP_Hello_ReqPDU;
        }
        if (frameIdValue == 65277) {
            return PnDcp_FrameId.DCP_GetSet_PDU;
        }
        if (frameIdValue == 65278) {
            return PnDcp_FrameId.DCP_Identify_ReqPDU;
        }
        if (frameIdValue == 65279) {
            return PnDcp_FrameId.DCP_Identify_ResPDU;
        }
        if (frameIdValue == 65280) {
            return PnDcp_FrameId.PTCP_AnnouncePDU;
        }
        if (frameIdValue == 65312) {
            return PnDcp_FrameId.PTCP_FollowUpPDU;
        }
        if (frameIdValue == 65344) {
            return PnDcp_FrameId.PTCP_DelayReqPDU;
        }
        if (frameIdValue == 65345) {
            return PnDcp_FrameId.PTCP_DelayResPDUWithFollowUp;
        }
        if (frameIdValue == 65346) {
            return PnDcp_FrameId.PTCP_DelayFuResPDUWithFollowUp;
        }
        if (frameIdValue == 65347) {
            return PnDcp_FrameId.PTCP_DelayResPDUWithoutFollowUp;
        }
        if (frameIdValue >= 65408 && frameIdValue <= 65423) {
            return PnDcp_FrameId.FragmentationFrameId;
        }
        return PnDcp_FrameId.RESERVED;
    }

    public static boolean isSysexEnd(ReadBuffer io) {
        return ((ReadBufferByteBased)io).getBytes(io.getPos(), io.getPos() + 2)[1] == 0;
    }

    public static LldpUnit parseSysexString(ReadBuffer io) {
        try {
            LldpUnit unit = LldpUnit.staticParse(io);
            return unit;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static void serializeSysexString(WriteBuffer io, LldpUnit unit) {
        try {
            unit.serialize(io);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
    }

    public static int lengthSysexString(List<LldpUnit> data) {
        int lengthInBytes = 0;
        for (LldpUnit unit : data) {
            lengthInBytes += unit.getLengthInBytes();
        }
        return lengthInBytes;
    }

    public static void writeDataUnit(WriteBuffer writeBuffer, PnIo_CyclicServiceDataUnit dataUnit) throws SerializationException {
        dataUnit.serialize(writeBuffer);
    }

    public static PnIo_CyclicServiceDataUnit readDataUnit(ReadBuffer readBuffer) throws ParseException {
        int NO_TRAILING_BYTES = 4;
        int initialPos = readBuffer.getPos();
        while (readBuffer.hasMore(8)) {
            readBuffer.readByte(new WithReaderArgs[0]);
        }
        int dataUnitLength = readBuffer.getPos() - initialPos - NO_TRAILING_BYTES;
        readBuffer.reset(initialPos);
        return PnIo_CyclicServiceDataUnit.staticParse(readBuffer, (short)dataUnitLength);
    }

    public static boolean isNullUuid(Uuid uuid) {
        return Arrays.equals(uuid.getData(), nullUuid);
    }
}

