/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.tag;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;

public class ProfinetTag
implements PlcTag {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?<slot>\\d+).(?<subSlot>\\d+).(?<direction>INPUT|OUTPUT)(.(?<index>\\d+))?:(?<dataType>[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private final int slot;
    private final int subSlot;
    private final Direction direction;
    private final int index;
    private final PlcValueType dataType;
    private final int numElements;

    public ProfinetTag(int slot, int subSlot, Direction direction, int index, PlcValueType dataType, int numElements) {
        this.slot = slot;
        this.subSlot = subSlot;
        this.direction = direction;
        this.index = index;
        this.dataType = dataType;
        this.numElements = numElements;
        if (this.numElements <= 0) {
            throw new IllegalArgumentException("numElements must be greater than zero. Was " + this.numElements);
        }
    }

    public static ProfinetTag of(String addressString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (!matcher.matches()) {
            throw new PlcInvalidTagException(addressString, ADDRESS_PATTERN);
        }
        int slot = Integer.parseInt(matcher.group("slot"));
        int subSlot = Integer.parseInt(matcher.group("subSlot"));
        Direction direction = Direction.valueOf(matcher.group("direction"));
        int index = Integer.parseInt(matcher.group("index"));
        PlcValueType dataType = PlcValueType.valueOf((String)matcher.group("dataType"));
        int numElements = matcher.group("numElements") != null ? Integer.parseInt(matcher.group("numElements")) : 1;
        return new ProfinetTag(slot, subSlot, direction, index, dataType, numElements);
    }

    public int getSlot() {
        return this.slot;
    }

    public int getSubSlot() {
        return this.subSlot;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int getIndex() {
        return this.index;
    }

    public int getNumElements() {
        return this.numElements;
    }

    public String getAddressString() {
        return String.format("%d.%d.%s.%d:%s%s", new Object[]{this.slot, this.subSlot, this.direction, this.index, this.dataType, this.numElements > 1 ? "[" + this.numElements + "]" : ""});
    }

    public PlcValueType getPlcValueType() {
        return this.dataType;
    }

    public List<ArrayInfo> getArrayInfo() {
        return super.getArrayInfo();
    }

    public static enum Direction {
        INPUT,
        OUTPUT;

    }
}

