/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum DataTransportErrorCode {
  RESERVED((short) 0x00),
  OK((short) 0xFF),
  ACCESS_DENIED((short) 0x03),
  INVALID_ADDRESS((short) 0x05),
  DATA_TYPE_NOT_SUPPORTED((short) 0x06),
  NOT_FOUND((short) 0x0A);
  private static final Map<Short, DataTransportErrorCode> map;

  static {
    map = new HashMap<>();
    for (DataTransportErrorCode value : DataTransportErrorCode.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private short value;

  DataTransportErrorCode(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static DataTransportErrorCode enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
