/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum DataTransportSize {
  NULL((short) 0x00, (boolean) false),
  BIT((short) 0x03, (boolean) true),
  BYTE_WORD_DWORD((short) 0x04, (boolean) true),
  INTEGER((short) 0x05, (boolean) true),
  DINTEGER((short) 0x06, (boolean) false),
  REAL((short) 0x07, (boolean) false),
  OCTET_STRING((short) 0x09, (boolean) false);
  private static final Map<Short, DataTransportSize> map;

  static {
    map = new HashMap<>();
    for (DataTransportSize value : DataTransportSize.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private short value;
  private boolean sizeInBits;

  DataTransportSize(short value, boolean sizeInBits) {
    this.value = value;
    this.sizeInBits = sizeInBits;
  }

  public short getValue() {
    return value;
  }

  public boolean getSizeInBits() {
    return sizeInBits;
  }

  public static DataTransportSize firstEnumForFieldSizeInBits(boolean fieldValue) {
    for (DataTransportSize _val : DataTransportSize.values()) {
      if (_val.getSizeInBits() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<DataTransportSize> enumsForFieldSizeInBits(boolean fieldValue) {
    List<DataTransportSize> _values = new ArrayList();
    for (DataTransportSize _val : DataTransportSize.values()) {
      if (_val.getSizeInBits() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static DataTransportSize enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
