/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class S7ParameterSetupCommunication extends S7Parameter implements Message {

  // Accessors for discriminator values.
  public Short getParameterType() {
    return (short) 0xF0;
  }

  public Short getMessageType() {
    return 0;
  }

  // Properties.
  protected final int maxAmqCaller;
  protected final int maxAmqCallee;
  protected final int pduLength;
  // Reserved Fields
  private Short reservedField0;

  public S7ParameterSetupCommunication(int maxAmqCaller, int maxAmqCallee, int pduLength) {
    super();
    this.maxAmqCaller = maxAmqCaller;
    this.maxAmqCallee = maxAmqCallee;
    this.pduLength = pduLength;
  }

  public int getMaxAmqCaller() {
    return maxAmqCaller;
  }

  public int getMaxAmqCallee() {
    return maxAmqCallee;
  }

  public int getPduLength() {
    return pduLength;
  }

  @Override
  protected void serializeS7ParameterChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("S7ParameterSetupCommunication");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 8));

    // Simple Field (maxAmqCaller)
    writeSimpleField("maxAmqCaller", maxAmqCaller, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (maxAmqCallee)
    writeSimpleField("maxAmqCallee", maxAmqCallee, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (pduLength)
    writeSimpleField("pduLength", pduLength, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("S7ParameterSetupCommunication");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    S7ParameterSetupCommunication _value = this;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (maxAmqCaller)
    lengthInBits += 16;

    // Simple field (maxAmqCallee)
    lengthInBits += 16;

    // Simple field (pduLength)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static S7ParameterSetupCommunicationBuilder staticParseBuilder(
      ReadBuffer readBuffer, Short messageType) throws ParseException {
    readBuffer.pullContext("S7ParameterSetupCommunication");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

    int maxAmqCaller = readSimpleField("maxAmqCaller", readUnsignedInt(readBuffer, 16));

    int maxAmqCallee = readSimpleField("maxAmqCallee", readUnsignedInt(readBuffer, 16));

    int pduLength = readSimpleField("pduLength", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("S7ParameterSetupCommunication");
    // Create the instance
    return new S7ParameterSetupCommunicationBuilder(
        maxAmqCaller, maxAmqCallee, pduLength, reservedField0);
  }

  public static class S7ParameterSetupCommunicationBuilder
      implements S7Parameter.S7ParameterBuilder {
    private final int maxAmqCaller;
    private final int maxAmqCallee;
    private final int pduLength;
    private final Short reservedField0;

    public S7ParameterSetupCommunicationBuilder(
        int maxAmqCaller, int maxAmqCallee, int pduLength, Short reservedField0) {
      this.maxAmqCaller = maxAmqCaller;
      this.maxAmqCallee = maxAmqCallee;
      this.pduLength = pduLength;
      this.reservedField0 = reservedField0;
    }

    public S7ParameterSetupCommunication build() {
      S7ParameterSetupCommunication s7ParameterSetupCommunication =
          new S7ParameterSetupCommunication(maxAmqCaller, maxAmqCallee, pduLength);
      s7ParameterSetupCommunication.reservedField0 = reservedField0;
      return s7ParameterSetupCommunication;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof S7ParameterSetupCommunication)) {
      return false;
    }
    S7ParameterSetupCommunication that = (S7ParameterSetupCommunication) o;
    return (getMaxAmqCaller() == that.getMaxAmqCaller())
        && (getMaxAmqCallee() == that.getMaxAmqCallee())
        && (getPduLength() == that.getPduLength())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getMaxAmqCaller(), getMaxAmqCallee(), getPduLength());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
