/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class S7PayloadDiagnosticMessage extends S7PayloadUserDataItem implements Message {

  // Accessors for discriminator values.
  public Byte getCpuFunctionType() {
    return (byte) 0x00;
  }

  public Short getCpuSubfunction() {
    return (short) 0x03;
  }

  public Integer getDataLength() {
    return 0;
  }

  // Properties.
  protected final int EventId;
  protected final short PriorityClass;
  protected final short ObNumber;
  protected final int DatId;
  protected final int Info1;
  protected final long Info2;
  protected final DateAndTime TimeStamp;

  public S7PayloadDiagnosticMessage(
      DataTransportErrorCode returnCode,
      DataTransportSize transportSize,
      int EventId,
      short PriorityClass,
      short ObNumber,
      int DatId,
      int Info1,
      long Info2,
      DateAndTime TimeStamp) {
    super(returnCode, transportSize);
    this.EventId = EventId;
    this.PriorityClass = PriorityClass;
    this.ObNumber = ObNumber;
    this.DatId = DatId;
    this.Info1 = Info1;
    this.Info2 = Info2;
    this.TimeStamp = TimeStamp;
  }

  public int getEventId() {
    return EventId;
  }

  public short getPriorityClass() {
    return PriorityClass;
  }

  public short getObNumber() {
    return ObNumber;
  }

  public int getDatId() {
    return DatId;
  }

  public int getInfo1() {
    return Info1;
  }

  public long getInfo2() {
    return Info2;
  }

  public DateAndTime getTimeStamp() {
    return TimeStamp;
  }

  @Override
  protected void serializeS7PayloadUserDataItemChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("S7PayloadDiagnosticMessage");

    // Simple Field (EventId)
    writeSimpleField("EventId", EventId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (PriorityClass)
    writeSimpleField("PriorityClass", PriorityClass, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (ObNumber)
    writeSimpleField("ObNumber", ObNumber, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (DatId)
    writeSimpleField("DatId", DatId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (Info1)
    writeSimpleField("Info1", Info1, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (Info2)
    writeSimpleField("Info2", Info2, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (TimeStamp)
    writeSimpleField("TimeStamp", TimeStamp, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("S7PayloadDiagnosticMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    S7PayloadDiagnosticMessage _value = this;

    // Simple field (EventId)
    lengthInBits += 16;

    // Simple field (PriorityClass)
    lengthInBits += 8;

    // Simple field (ObNumber)
    lengthInBits += 8;

    // Simple field (DatId)
    lengthInBits += 16;

    // Simple field (Info1)
    lengthInBits += 16;

    // Simple field (Info2)
    lengthInBits += 32;

    // Simple field (TimeStamp)
    lengthInBits += TimeStamp.getLengthInBits();

    return lengthInBits;
  }

  public static S7PayloadDiagnosticMessageBuilder staticParseBuilder(
      ReadBuffer readBuffer, Byte cpuFunctionType, Short cpuSubfunction) throws ParseException {
    readBuffer.pullContext("S7PayloadDiagnosticMessage");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int EventId = readSimpleField("EventId", readUnsignedInt(readBuffer, 16));

    short PriorityClass = readSimpleField("PriorityClass", readUnsignedShort(readBuffer, 8));

    short ObNumber = readSimpleField("ObNumber", readUnsignedShort(readBuffer, 8));

    int DatId = readSimpleField("DatId", readUnsignedInt(readBuffer, 16));

    int Info1 = readSimpleField("Info1", readUnsignedInt(readBuffer, 16));

    long Info2 = readSimpleField("Info2", readUnsignedLong(readBuffer, 32));

    DateAndTime TimeStamp =
        readSimpleField(
            "TimeStamp",
            new DataReaderComplexDefault<>(() -> DateAndTime.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("S7PayloadDiagnosticMessage");
    // Create the instance
    return new S7PayloadDiagnosticMessageBuilder(
        EventId, PriorityClass, ObNumber, DatId, Info1, Info2, TimeStamp);
  }

  public static class S7PayloadDiagnosticMessageBuilder
      implements S7PayloadUserDataItem.S7PayloadUserDataItemBuilder {
    private final int EventId;
    private final short PriorityClass;
    private final short ObNumber;
    private final int DatId;
    private final int Info1;
    private final long Info2;
    private final DateAndTime TimeStamp;

    public S7PayloadDiagnosticMessageBuilder(
        int EventId,
        short PriorityClass,
        short ObNumber,
        int DatId,
        int Info1,
        long Info2,
        DateAndTime TimeStamp) {

      this.EventId = EventId;
      this.PriorityClass = PriorityClass;
      this.ObNumber = ObNumber;
      this.DatId = DatId;
      this.Info1 = Info1;
      this.Info2 = Info2;
      this.TimeStamp = TimeStamp;
    }

    public S7PayloadDiagnosticMessage build(
        DataTransportErrorCode returnCode, DataTransportSize transportSize) {
      S7PayloadDiagnosticMessage s7PayloadDiagnosticMessage =
          new S7PayloadDiagnosticMessage(
              returnCode,
              transportSize,
              EventId,
              PriorityClass,
              ObNumber,
              DatId,
              Info1,
              Info2,
              TimeStamp);
      return s7PayloadDiagnosticMessage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof S7PayloadDiagnosticMessage)) {
      return false;
    }
    S7PayloadDiagnosticMessage that = (S7PayloadDiagnosticMessage) o;
    return (getEventId() == that.getEventId())
        && (getPriorityClass() == that.getPriorityClass())
        && (getObNumber() == that.getObNumber())
        && (getDatId() == that.getDatId())
        && (getInfo1() == that.getInfo1())
        && (getInfo2() == that.getInfo2())
        && (getTimeStamp() == that.getTimeStamp())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getEventId(),
        getPriorityClass(),
        getObNumber(),
        getDatId(),
        getInfo1(),
        getInfo2(),
        getTimeStamp());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
